% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_cols.}
\alias{bind_cols.}
\alias{bind_rows.}
\title{Bind data.tables by row and column}
\usage{
bind_cols.(...)

bind_rows.(..., .id = NULL, .use_names = TRUE, .fill = TRUE)
}
\arguments{
\item{...}{data.tables or data.frames to bind}

\item{.id}{If TRUE, an integer column is made as a group id}

\item{.use_names}{If TRUE, makes sure column names align}

\item{.fill}{If TRUE, fills missing columns with NA}
}
\description{
Bind multiple data.tables into one row-wise or col-wise.
}
\examples{
df1 <- data.table(x = c(1,2,3), y = c(3,4,5))
df2 <- data.table(x = c(1,2,3), y = c(3,4,5))

df1 \%>\%
  bind_rows.(df2)

bind_rows.(list(df1, df2))

df1 \%>\%
  bind_cols.(df2)

bind_cols.(list(df1, df2))
}
