% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_n.R
\name{top_n.}
\alias{top_n.}
\title{Select top (or bottom) n rows (by value)}
\usage{
top_n.(.df, n = 5, wt = NULL, .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{n}{Number of rows to return}

\item{wt}{Optional. The variable to use for ordering. If NULL uses the last column in the data.table.}

\item{.by}{Columns to group by}
}
\description{
Select the top or bottom entries in each group, ordered by \code{wt}.
}
\examples{
test_df <- data.table(
  x = 1:5,
  y = 6:10,
  z = c(rep("a", 3), rep("b", 2)))

test_df \%>\%
  top_n.(2, wt = y)

test_df \%>\%
  top_n.(2, wt = y, .by = z)
}
