% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_when.R
\name{case_when.}
\alias{case_when.}
\title{Case when}
\usage{
case_when.(...)
}
\arguments{
\item{...}{A sequence of two-sided formulas. The left hand side gives the conditions,
the right hand side gives the values.}
}
\description{
This function allows you to use multiple if/else statements in one call.

It is called like \code{dplyr::case_when()}, but utilizes \code{data.table::fifelse()}
in the background for improved performance.
}
\examples{
test_df <- tidytable(x = 1:10)

test_df \%>\%
  mutate.(case_x = case_when.(x < 5 ~ 1,
                              x < 7 ~ 2,
                              TRUE ~ 3))
}
