% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{arrange.}
\alias{arrange.}
\title{Arrange/reorder rows}
\usage{
arrange.(.df, ...)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Variables to arrange by}
}
\description{
Order rows in ascending or descending order.

Note: \code{data.table} orders character columns slightly differently than \code{dplyr::arrange()} by
ordering in the "C-locale". See \code{?data.table::setorder} for more details.
}
\examples{
test_df <- data.table(
  a = 1:3,
  b = 4:6,
  c = c("a","a","b")
)

test_df \%>\%
  arrange.(c, -a)

test_df \%>\%
  arrange.(c, desc(a))
}
