% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind-cols-SpatVector.R
\name{bind_cols.SpatVector}
\alias{bind_cols.SpatVector}
\alias{bind_spat_cols}
\title{Bind multiple \code{SpatVector} \code{sf} and data frames objects by column}
\usage{
bind_spat_cols(
  ...,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)
}
\arguments{
\item{...}{Objects to combine. The first argument should be a \code{SpatVector}
and each of the subsequent arguments can either be a \code{SpatVector}, a \code{sf}
object or a data frame. Inputs are \link[dplyr:bind_cols]{recycled} to the
same length, then matched by position.}

\item{.name_repair}{One of \code{"unique"}, \code{"universal"}, or \code{"check_unique"}.
See \code{\link[dplyr:bind_cols]{dplyr::bind_cols()}} for \strong{Details}.}
}
\value{
A \code{SpatVector} with the corresponding columns. The geometry and CRS
would correspond to the the first \code{SpatVector} of \code{...}.
}
\description{
Bind any number of \code{SpatVector}, data frames and \code{sf} object by column,
making a wider result. This is similar to \code{do.call(cbind, dfs)}.

Where possible prefer using a \link[=mutate-joins.SpatVector]{join} to combine
\code{SpatVector} and data frames objects. \code{bind_spat_cols()} binds the rows in
order in which they appear so it is easy to create meaningless results
without realizing it.
}
\section{\CRANpkg{terra} equivalent}{


\code{cbind()} method
}

\section{Methods}{


Implementation of the \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}} function for
\code{SpatVector} objects. Note that for the second and subsequent arguments on
\code{...} the geometry would not be \code{cbind}ed, and only the data frame (-ish)
columns would be kept.
}

\examples{
library(terra)
sv <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))
df2 <- data.frame(letters = letters[seq_len(nrow(sv))])

# Data frame
bind_spat_cols(sv, df2)


# Another SpatVector
bind_spat_cols(sv[1:2, ], sv[3:4, ])

# sf objects
sfobj <- sf::read_sf(system.file("shape/nc.shp", package = "sf"))

bind_spat_cols(sv[1:9, ], sfobj[1:9, ])

# Mixed

end <- bind_spat_cols(sv, sfobj[seq_len(nrow(sv)), 1:2], df2)

end
glimpse(end)

# Row sizes must be compatible when column-binding
try(bind_spat_cols(sv, sfobj))
}
\seealso{
\code{\link[dplyr:bind_cols]{dplyr::bind_cols()}}

Other \CRANpkg{dplyr} verbs that operate on pairs \code{Spat*}/data.frame:
\code{\link{bind_rows.SpatVector}},
\code{\link{filter-joins.SpatVector}},
\code{\link{mutate-joins.SpatVector}}

Other \CRANpkg{dplyr} methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.methods}
\concept{dplyr.pairs}
