% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{lump_rows}
\alias{lump_rows}
\title{Lump rows of a tibble}
\usage{
lump_rows(.df, .level, .count, summarising_statements = quos(), n, prop,
  remaining_levels, other_level = "Other", ties.method = c("min",
  "average", "first", "last", "random", "max"))
}
\arguments{
\item{.df}{A data frame}

\item{.level}{Column name (symbolic) containing a set of levels}

\item{.count}{Column name (symbolic) containing counts of the levels}

\item{summarising_statements}{The "lumped" rows need to have all their columns summarised into one row.
This parameter is a vars() list of arguments as if used in a call to \code{\link{summarise}()},
name is column name, value is language.
If not provided for a column, a default summary will be used
which takes the sum if numeric, concatenates text, or uses any() if logical.}

\item{n}{If specified, n rows shall be preserved.}

\item{prop}{If specified, rows shall be preserved if their count >= prop}

\item{remaining_levels}{Levels that should explicitly not be lumped}

\item{other_level}{Name of the "other" level to be created from lumped rows}

\item{ties.method}{Method to apply in case of ties}
}
\value{
The lumped data frame
}
\description{
A verb for a dplyr pipeline:
In the given data frame, take the .level column as a set of levels and the .count column
as corresponding counts. Return a data frame where the rows are lumped according to levels/counts
using the parameters n, prop, other_level, ties.method like for \code{\link{lump}()}.
The resulting row for other_level has \code{level=other level}, \code{count=sum(count of all lumped rows)}.
For the remaining columns, either a default concatenation is used, or you can provide
custom summarising statements via the summarising_statements parameter.
Provide a list named by the column you want to summarize, giving statements wrapped in quo(),
using syntax as you would for a call to summarise().
}
\seealso{
\code{\link{lump}}
}
