% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{read_gtfs}
\alias{read_gtfs}
\title{Get and validate dataframes of General Transit Feed Specification (GTFS) data.}
\usage{
read_gtfs(path, quiet = TRUE)
}
\arguments{
\item{path}{Character. URL link to zip file OR path to local zip file.}

\item{quiet}{Boolean. Whether to see file download progress and files extract. FALSE by default.}
}
\value{
A GTFS object. That is, a list of dataframes of GTFS data.
}
\description{
This function reads GTFS text files from a local or remote zip file.
It also validates the files against the GTFS specification by file, requirement status,
and column name.
}
\details{
The data are returned as a list of dataframes and a validation object,
which contains details on whether all required files were found,
and which required and optional columns are present.
#'
}
\examples{
\donttest{
library(dplyr)
u1 <- "https://github.com/r-transit/tidytransit/raw/master/inst/extdata/sample-feed-fixed.zip"
sample_gtfs <- read_gtfs(u1)
attach(sample_gtfs)
#list routes by the number of stops they have
routes \%>\% inner_join(trips, by="route_id") \%>\%
  inner_join(stop_times) \%>\%
    inner_join(stops, by="stop_id") \%>\%
      group_by(route_long_name) \%>\%
        summarise(stop_count=n_distinct(stop_id)) \%>\%
          arrange(desc(stop_count))
}
}
