% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_stops}
\alias{filter_stops}
\title{Get a set of stops for a given set of service ids and route ids}
\usage{
filter_stops(gtfs_obj, service_ids, route_ids)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object)}

\item{service_ids}{the service for which to get stops}

\item{route_ids}{the route_ids for which to get stops}
}
\value{
stops table for a given service or route
}
\description{
Get a set of stops for a given set of service ids and route ids
}
\examples{
\donttest{
library(dplyr)
local_gtfs_path <- system.file("extdata", "nyc_subway.zip", package = "tidytransit")
nyc <- read_gtfs(local_gtfs_path)
select_service_id <- filter(nyc$calendar, monday==1) \%>\% pull(service_id)
select_route_id <- sample_n(nyc$routes, 1) \%>\% pull(route_id)
filtered_stops_df <- filter_stops(nyc, select_service_id, select_route_id)
}
}
