% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{censoring}
\alias{censoring}
\alias{censoring.tidyvpcobj}
\title{censoring}
\usage{
censoring(o, ...)

\method{censoring}{tidyvpcobj}(o, blq, lloq, alq, uloq, data = o$data, ...)
}
\arguments{
\item{o}{tidyvpc object}

\item{...}{Other arguments to include}

\item{blq}{blq variable if present in observed data}

\item{lloq}{lloq variable if present in observed data. Use numeric to specify lloq value}

\item{alq}{logical variable indicating above limit of quantification}

\item{uloq}{number or numeric variable in data indicating the upper limit of quantification}

\item{data}{observed data supplied in \code{observed()} function}
}
\value{
Updates \code{obs} \code{data.frame} in \code{tidypcobj} with censored values for observed data which includes \code{lloq} and \code{uloq} specified 
 values for lower/upper limit of quantification. Logicals for \code{blq} and \code{alq} are returned which indicate whether the DV value lies below/above limit 
 of quantification.
}
\description{
Censoring observed data for Visual Predictive Check (VPC)
}
\details{
Specify censoring variables or censoring value for VPC using this function
}
\examples{
obs_data <- as.data.table(tidyvpc::obs_data)
sim_data <- as.data.table(tidyvpc::sim_data)

vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    censoring(blq=(DV < 50), lloq=50) \%>\%
    binning(bin = "pam", nbins = 5) \%>\%
    vpcstats()

#Using LLOQ variable in data with different values of LLOQ by Study:

obs_data$LLOQ <- obs_data[, ifelse(STUDY == "Study A", 50, 25)]

vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    censoring(blq=(DV < LLOQ), lloq=LLOQ) \%>\%
    stratify(~ STUDY) \%>\%
    binning(bin = "kmeans", nbins = 4) \%>\%
    vpcstats()

 
}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{stratify}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
