% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{simulated}
\alias{simulated}
\alias{simulated.tidyvpcobj}
\title{observed}
\usage{
simulated(o, ...)

\method{simulated}{tidyvpcobj}(o, data, ysim, ...)
}
\arguments{
\item{o}{tidyvpcobj}

\item{...}{other arguments}

\item{data}{data.frame or data.table of simulated data}

\item{ysim}{numeric y-variable, typically named DV}
}
\value{
A \code{tidyvpcobj} containing simulated dataset \code{sim} formatted with columns \code{x}, \code{y}, and \code{repl} which indicates the replicate number.
 The column \code{x} is used from the \code{observed()} function. Resulting dataset is of class \code{data.frame} and \code{data.table}.
}
\description{
Specify simulated dataset and variables for VPC
}
\details{
The simulated function is used for specifying simulated input data and variables for VPC. Note: Simulated data must not 
contain missing DV and may require subsetting \code{MDV == 0} before generating VPC. The ordering of observed and simulated 
data must also be consistent, with replicates in simulated data stacked on top of each other.
}
\examples{
vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) 
    
}
\seealso{
\code{\link{observed}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
