% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_sheet_names.R
\name{xlsx_sheet_names}
\alias{xlsx_sheet_names}
\title{List sheets in an xlsx (Excel) file}
\usage{
xlsx_sheet_names(path, check_filetype = TRUE)
}
\arguments{
\item{path}{Path to the xlsx file.}

\item{check_filetype}{Logical. Whether to check that the filetype is xlsx (or
xlsm) by looking at the file itself, rather than using the filename
extension.}
}
\value{
A character vector of the names of the worksheets in the file.
}
\description{
\code{xlsx_sheets()} returns the names of the sheets in a workbook, as a character
vector.  They are in the same order as they appear in the spreadsheet when it
is opened with a spreadsheet application like Excel or LibreOffice.
}
\examples{
examples <- system.file("extdata/examples.xlsx", package = "tidyxl")
xlsx_sheet_names(examples)
}
