% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/legislative.R
\name{state_legislative_districts}
\alias{state_legislative_districts}
\title{Download a state legislative districts shapefile into R - upper or lower}
\usage{
state_legislative_districts(state, house = "upper", cb = FALSE,
  detailed = TRUE, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state. Can also be state
name or abbreviation (case-insensitive)}

\item{house}{Specify here whether you want boundaries for the \code{upper} or
\code{lower} house.  Defaults to \code{upper}.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{detailed}{(deprecated) Setting detailed to FALSE returns a 1:500k cartographic boundary file.
This parameter will be removed in a future release.}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}), and \code{year}, the year for which you'd like to download data
(defaults to 2014).}
}
\description{
This function allows you to download boundaries for state legislatures into R.
Generally, state legislatures are comprised of an "upper" house, which is
typically referred to as the Senate, and a "lower" house, which is often (but
not exclusively) referred to as the House.  The exception is Nebraska, which
has a unicameral state legislature.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

leg <- state_legislative_districts("Maine", "lower", cb = TRUE)

leaflet(leg) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5)
}
}
\seealso{
Other legislative district functions: \code{\link{congressional_districts}}
}

