% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Attribute.R
\name{tiledb_attr}
\alias{tiledb_attr}
\title{Contructs a \code{tiledb_attr} object}
\usage{
tiledb_attr(
  name,
  type,
  filter_list = tiledb_filter_list(),
  ncells = 1,
  nullable = FALSE,
  ctx = tiledb_get_context()
)
}
\arguments{
\item{name}{The dimension name / label string; if missing default \code{""} is used.}

\item{type}{The tiledb_attr TileDB datatype string; if missing the user is alerted
that this is a \emph{required} parameter.}

\item{filter_list}{(default filter_list("NONE")) An optional tiledb_filter_list object}

\item{ncells}{(default 1) The number of cells, use \code{NA} to signal variable length}

\item{nullable}{(default FALSE) A logical switch whether the attribute can have missing
values}

\item{ctx}{tiledb_ctx object (optional)}
}
\value{
\code{tiledb_dim} object
}
\description{
Contructs a \code{tiledb_attr} object
}
\examples{
\dontshow{ctx <- tiledb_ctx(limitTileDBCores())}
flt <- tiledb_filter_list(list(tiledb_filter("GZIP")))
attr <- tiledb_attr(name = "a1", type = "INT32",
                    filter_list = flt)
attr

}
