% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly5_hi.R
\name{poly5_hi}
\alias{poly5_hi}
\title{Estimate the height at which a given diameter occurs in a tree, based on a 5th degree polynomial function.}
\usage{
poly5_hi(dbh, h, di, coef)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{di}{diameter whose height of occurrence will be estimated, in centimeters.}

\item{coef}{numerical vector containing six coefficients of the 5th degree polynomial function that describes the tree's taper.}
}
\value{
as numeric value indicating the height at which the given diameter occurs.
}
\description{
Estimates the height at which a given diameter occurs in a tree, from the diameter at breast height, total height and coefficients of the 5th degree polynomial function that describes the tree's taper.
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

poli5 <- lm(did~hih+I(hih^2)+I(hih^3)+I(hih^4)+I(hih^5),tree_scaling)

coef_poli <- coef(poli5)

dbh <- 25
h <- 20
hi <- 15

poly5_hi(dbh, h, hi, coef_poli)

}
