% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_lag.R
\name{roll_lag}
\alias{roll_lag}
\alias{lag_seq}
\title{Fast rolling lag}
\usage{
roll_lag(x, lag = 1L, check = TRUE)

lag_seq(x, lag = 1L)
}
\arguments{
\item{x}{A vector.}

\item{lag}{A vector of lags to be applied to \code{x} on a rolling basis.}

\item{check}{Should safety checks be done for the specified lag  against \code{x}?

The default is \code{TRUE} but
you can set this to \code{FALSE} if you need this to be speed-performant.}
}
\value{
A lagged vector of \code{x} the same length as \code{x}.
}
\description{
An efficient rolling lag.

\code{lag_seq()} is a helper that creates a safe vector of lags.
}
\details{
This function is simple and fast. It should generally be equivalent to
\code{diag(matrix(unlist(data.table::shift(x, lag)), ncol = length(x)))}. \cr
where \code{length(lag) = length(x)}.
}
\examples{
library(timeplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
x <- 1:10

roll_lag(x, 2) # Lag
roll_lag(x, -2) # Lead


roll_lag(x, lag_seq(x, 2), check = FALSE) # Lag
roll_lag(x, lag_seq(x, -2), check = FALSE) # Lead
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
