% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fselect.R
\name{fselect}
\alias{fselect}
\alias{frename}
\title{Fast \code{dplyr::select()}/\code{dplyr::rename()}}
\usage{
fselect(data, ..., .cols = NULL)

frename(data, ..., .cols = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Variables to select using \code{tidy-select}.
See \code{?dplyr::select} for more info.}

\item{.cols}{(Optional) faster alternative to \code{...} that accepts
a named character vector or numeric vector. \cr
No checks on duplicates column names are done when using \code{.cols}. \cr
If speed is an expensive resource, it is recommended to use this.}
}
\value{
A \code{data.frame} of selected columns.
}
\description{
\code{fselect()} operates the exact same way as \code{dplyr::select()} and
can be used naturally with \code{tidy-select} helpers.
It uses collapse to perform the actual selecting of variables and is
considerably faster than dplyr for selecting exact columns,
and even more so when supplying the \code{.cols} argument.
}
\examples{
library(timeplyr)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
df <- slice_head(iris, n = 5)
fselect(df, Species, SL = Sepal.Length)
fselect(df, .cols = c("Species", "Sepal.Length"))
fselect(df, all_of(c("Species", "Sepal.Length")))
fselect(df, 5, 1)
fselect(df, .cols = c(5, 1))
df \%>\%
  fselect(where(is.numeric))
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
