% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/quickHandleOps.R
\name{\%k\%}
\alias{\%k\%}
\alias{createMetaDataHandle}
\title{Search the Database by Keys}
\usage{
conObj \%k\% regexp

createMetaDataHandle(key, keep_keys = FALSE, tbl = "meta_data_unlocalized",
  schema = "timeseries")
}
\arguments{
\item{conObj}{PostgreSQL Connection object.}

\item{regexp}{character regular expression pattern.
Do not set this manually, because the quick handle operator only takes two arguments.
use Sys.setenv to change the schema.}

\item{key}{character name of the key inside the hstore.}

\item{keep_keys}{logical should primary time series keys be kept? Defaults to FALSE. If set to TRUE
dynamically created meta information handlers always use ts_key as key type no matter the key type used for the query.
This comes handy when storing sets of time series.}

\item{tbl}{character name of the table that holds meta data. Defaults to meta_data_unlocalized.
Also supports meta_data_localized}

\item{schema}{character database schema name. Defaults to timeseries.}
}
\description{
Quick handle operator to search the database by keys. All time series whose key fit
the regular expression which was handed to the operator are returned in a list.

Create '%letter%' style operator to conveniently access meta data by hstore keys.
This function creates a new function operator for a particular key. Name the function
operator style to get the most out of it.
}

