% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsample-time_series_split.R
\name{time_series_split}
\alias{time_series_split}
\title{Simple Training/Test Set Splitting for Time Series}
\usage{
time_series_split(
  data,
  date_var = NULL,
  initial = 5,
  assess = 1,
  skip = 1,
  lag = 0,
  cumulative = FALSE,
  slice = 1,
  point_forecast = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{date_var}{A date or date-time variable.}

\item{initial}{The number of samples used for analysis/modeling in the
initial resample.}

\item{assess}{The number of samples used for each assessment resample.}

\item{skip}{A integer indicating how many (if any) \emph{additional} resamples
to skip to thin the total amount of data points in the analysis resample.
See the example below.}

\item{lag}{A value to include an lag between the assessment
and analysis set. This is useful if lagged predictors will be used
during training and testing.}

\item{cumulative}{A logical. Should the analysis resample grow beyond the
size specified by \code{initial} at each resample?.}

\item{slice}{Returns a single slice from \link{time_series_cv}}

\item{point_forecast}{Whether or not to have the testing set be a single point forecast or to be a forecast horizon.
The default is to be a forecast horizon. Default: \code{FALSE}}

\item{...}{Not currently used.}
}
\value{
An \code{rsplit} object that can be used with the \code{training} and \code{testing}
functions to extract the data in each split.
}
\description{
\code{time_series_split} creates resample splits using \code{\link[=time_series_cv]{time_series_cv()}} but
returns only a \strong{single split.} This is useful when creating a single
train/test split.
}
\details{
\strong{Time-Based Specification}

The \code{initial}, \code{assess}, \code{skip}, and \code{lag} variables can be specified as:
\itemize{
\item Numeric: \code{initial = 24}
\item Time-Based Phrases: \code{initial = "2 years"}, if the \code{data} contains
a \code{date_var} (date or datetime)
}

\strong{Initial (Training Set) and Assess (Testing Set)}

The main options, \code{initial} and \code{assess}, control the number of
data points from the original data that are in the analysis (training set)
and the assessment (testing set), respectively.

\strong{Skip}

\code{skip} enables the function to not use every data point in the resamples.
When \code{skip = 1}, the resampling data sets will increment by one position.

Example: Suppose that the rows of a data set are consecutive days. Using \code{skip = 7}
will make the analysis data set operate on \emph{weeks} instead of days. The
assessment set size is not affected by this option.

\strong{Lag}

The Lag parameter creates an overlap between the Testing set. This is needed
when lagged predictors are used.

\strong{Cumulative vs Sliding Window}

When \code{cumulative = TRUE}, the \code{initial} parameter is ignored and the
analysis (training) set will grow as
resampling continues while the assessment (testing) set size will always remain
static.

When \code{cumulative = FALSE}, the \code{initial} parameter fixes the analysis (training)
set and resampling occurs over a fixed window.

\strong{Slice}

This controls which slice is returned. If \code{slice = 1}, only the most recent
slice will be returned.
}
\examples{
library(dplyr)
library(timetk)

# DATA ----
m750 <- m4_monthly \%>\% filter(id == "M750")

# Get the most recent 3 years as testing, and previous 10 years as training
m750 \%>\%
    time_series_split(initial = "10 years", assess = "3 years")

# Skip the most recent 3 years
m750 \%>\%
    time_series_split(
        initial = "10 years",
        assess  = "3 years",
        skip    = "3 years",
        slice   = 2          # <- Returns 2nd slice, 3-years back
    )

# Add 1 year lag for testing overlap
m750 \%>\%
    time_series_split(
        initial = "10 years",
        assess  = "3 years",
        skip    = "3 years",
        slice   = 2,
        lag     = "1 year"   # <- Overlaps training/testing by 1 year
    )


}
\seealso{
\itemize{
\item \code{\link[=time_series_cv]{time_series_cv()}} and \code{\link[rsample:rolling_origin]{rsample::rolling_origin()}} - Functions used to create
time series resample specifications.
}
}
