% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{addItems}
\alias{addItems}
\title{Add multiple items to a timeline}
\usage{
addItems(id, data)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{data}{A dataframe containing the items data to add.}
}
\description{
Add multiple items to a timeline
}
\examples{

timevis() \%>\%
  addItems(data.frame(start = c(Sys.Date(), Sys.Date() - 1),
           content = c("Today", "Yesterday")))

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Add items today and yesterday")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn, {
      addItems("timeline",
               data.frame(start = c(Sys.Date(), Sys.Date() - 1),
                          content = c("Today", "Yesterday")))
    })
  }
)
}
}

