% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{addItem}
\alias{addItem}
\title{Add a single item to a timeline}
\usage{
addItem(id, data)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{data}{A named list containing the item data to add.}
}
\description{
Add a single item to a timeline
}
\examples{

timevis() \%>\%
  addItem(list(start = Sys.Date(), content = "Today"))

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Add item today")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn, {
      addItem("timeline", list(start = Sys.Date(), content = "Today"))
    })
  }
)
}
}
