% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations.R
\name{expect_equal}
\alias{expect_equal}
\alias{expect_identical}
\alias{expect_equivalent}
\alias{expect_true}
\alias{expect_false}
\alias{expect_silent}
\alias{expect_null}
\alias{expect_error}
\alias{expect_warning}
\alias{expect_message}
\title{Express expectations}
\usage{
expect_equal(current, target, tol = sqrt(.Machine$double.eps), ...)

expect_identical(current, target)

expect_equivalent(current, target, tol = sqrt(.Machine$double.eps), ...)

expect_true(current)

expect_false(current)

expect_silent(current, quiet = TRUE)

expect_null(current)

expect_error(current, pattern = ".*")

expect_warning(current, pattern = ".*")

expect_message(current, pattern = ".*")
}
\arguments{
\item{current}{\code{[R object or expression]} Outcome or expression under scrutiny.}

\item{target}{\code{[R object or expression]} Expected outcome}

\item{tol}{\code{[numeric]} Test equality to machine rounding. Passed
to \code{\link[base]{all.equal} (tolerance)}}

\item{...}{Passed to \code{all.equal}}

\item{quiet}{\code{[logical]} suppress output printed by the \code{current} 
expression (see examples)}

\item{pattern}{\code{[character]} A regular expression to match the message.}
}
\value{
A \code{\link{tinytest}} object. A tinytest object is a
\code{logical} with attributes holding information about the
test that was run
}
\description{
Express expectations
}
\details{
\code{expect_equivalent} calls \code{expect_equal} with the extra
arguments \code{check.attributes=FALSE} and \code{use.names=FALSE}

\code{expect_silent} fails when an error or warning is thrown.
}
\note{
Each \code{expect_haha} function can also be called as \code{checkHaha}.
Although the interface is not entirely the same, it is expected that
this makes migration from the \code{RUnit} framework a little easier, for those
who wish to do so.
}
\section{More information and examples}{


\itemize{
\item{An overview of tinytest can be found in \code{vignette("using_tinytest")}}.
\item{Examples of how tinytest is used in practice can be found in
   \code{vignette("tinytest_examples")}}
}
}

\examples{
expect_equal(1 + 1, 2)       # TRUE
expect_equal(1 - 1, 2)       # FALSE
expect_equivalent(2, c(x=2)) # TRUE
expect_equal(2, c(x=2))      # FALSE


expect_silent(1+1)           # TRUE
expect_silent(1+"a")         # FALSE
expect_silent(print("hihi")) # TRUE, nothing goes to screen
expect_silent(print("hihi", quiet=FALSE)) # FALSE, and printed

}
\seealso{
Other test-functions: \code{\link{ignore}}
}
\concept{test-functions}
