% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicitationFunctions.R
\name{drawExpertWeightSample}
\alias{drawExpertWeightSample}
\title{Draw samples from expert opinions gathered in the roulette method.}
\usage{
drawExpertWeightSample(expertWeights, n, weights = NULL)
}
\arguments{
\item{expertWeights}{A data frame or matrix representing expert weights.
Rows should represent experts, columns should represent bins / weights.}

\item{n}{The number of samples to be drawn.}

\item{weights}{An optional vector containing the weight assigned to each expert. Defaults to uniform.}
}
\value{
Samples from a pooled distribution of expert opinions.
}
\description{
Returns samples drawn from a pooled distribution on specified expert weights.
}
\details{
The argument \code{expertWeights} must be a data frame or a matrix that represents the assigned
expert weights. It should contain a row for each expert and 10 columns for different weights.
The first column represents weights 0-0.1, second column represents weights 0.1-0.2 and so on.
}
\examples{
drawExpertWeightSample(
  expertWeights = rbind(
    c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0),
    c(0, 0, 0, 1, 2, 4, 2, 1, 0, 0),
    c(0, 0, 0, 2, 2, 2, 2, 2, 0, 0)
  ),
  n = 100
)
}
