% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip}
\alias{tip}
\alias{tip_with_continuous}
\alias{tip_c}
\title{Tip a result with a normally distributed confounder.}
\usage{
tip(
  effect_observed,
  exposure_confounder_effect = NULL,
  confounder_outcome_effect = NULL,
  verbose = TRUE,
  correction_factor = "none"
)

tip_with_continuous(
  effect_observed,
  exposure_confounder_effect = NULL,
  confounder_outcome_effect = NULL,
  verbose = TRUE,
  correction_factor = "none"
)

tip_c(
  effect_observed,
  exposure_confounder_effect = NULL,
  confounder_outcome_effect = NULL,
  verbose = TRUE,
  correction_factor = "none"
)
}
\arguments{
\item{effect_observed}{Numeric positive value. Observed exposure - outcome effect
(assumed to be the exponentiated coefficient, so a risk ratio, odds
ratio, or hazard ratio). This can be the point estimate, lower confidence
bound, or upper confidence bound.}

\item{exposure_confounder_effect}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{confounder_outcome_effect}{Numeric positive value. Estimated relationship
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{correction_factor}{Character string. Options are "none", "hr", "or".
For common outcomes (>15\%), the odds ratio or hazard ratio is not a good
estimate for the risk ratio. In these cases, we can apply a correction
factor. If you are supplying a hazard ratio for a common outcome, set
this to "hr"; if you are supplying an odds ratio for a common outcome, set
this to "or"; if you are supplying a risk ratio or your outcome is rare,
set this to "none" (default).}
}
\value{
Data frame.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{exposure_confounder_effect}
\item \code{confounder_outcome_effect}
}
}
\examples{
## to estimate the relationship between an unmeasured confounder and outcome
## needed to tip analysis
tip(1.2, exposure_confounder_effect = -2)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip(1.2, exposure_confounder_effect = -2, confounder_outcome_effect = .99)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  glm(am ~ mpg, data = mtcars, family = "binomial") \%>\%
   broom::tidy(conf.int = TRUE, exponentiate = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   dplyr::pull(conf.low) \%>\%
   tip(confounder_outcome_effect = 2.5)
}
}
