% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutp.R
\name{cutp}
\alias{cutp}
\title{Cut a numeric vector into quantiles}
\usage{
cutp(x, p, ...)
}
\arguments{
\item{x}{A numeric vector to be discretized}

\item{p}{A numeric vector of probabilities}

\item{...}{Arguments passed to `cut`}
}
\value{
Returns the output from `cut`. This is usually a factor unless otherwise specified.

#' @seealso \code{\link[stats]{quantile}}; \code{\link[base]{cut}}
}
\description{
\code{cutp} is a wrapper for the base `cut` function. The vector `x` will be categorized using the percentiles provided in `p` to create break values.
}
\details{
Within the `cutp` function, `p` is passed to `quantile` as the `probs` input. The computed quantiles are then used as the `breaks` in `cut`.

The values `-Inf` and `Inf` are added to the beginning and end of the breaks vector, respectively, so quantiles for 0 and 1 do not need to be given explicitly.
}
\examples{
myvals = rnorm(1000)
catx = cutp(x=myvals, p=c(0.25, 0.5, 0.75), labels=c('Q1', 'Q2', 'Q3', 'Q4'))
table(catx)

}
