% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qtm.R
\name{qtm}
\alias{qtm}
\title{Quick thematic map plot}
\usage{
qtm(shp, fill = "grey85", bubble.size = NULL, bubble.col = NULL,
  text = NULL, text.size = 1, line.lwd = NULL, line.col = NULL,
  raster = "grey70", borders = "grey40", theme = NULL, scale = NA,
  title = "", ...)
}
\arguments{
\item{shp}{shape object, which is one of
\enumerate{
 \item{\code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygons(DataFrame)}}}
 \item{\code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}}
 \item{\code{\link[sp:SpatialLinesDataFrame]{SpatialLines(DataFrame)}}}
 \item{\code{\link[sp:SpatialGridDataFrame]{SpatialGrid(DataFrame)}}}
 \item{\code{\link[sp:SpatialPixelsDataFrame]{SpatialPixels(DataFrame)}}}
 \item{\code{\link[raster:Raster-class]{RasterLayer, RasterStack, or RasterBrick}}}
}}

\item{fill}{either a color to fill the polygons, or name of the data variable in \code{shp} to draw a choropleth. Only applicable when \code{shp} is type 1 (see above).}

\item{bubble.size}{name of the data variable in \code{shp} for the bubble map that specifies the sizes of the bubbles. If neither \code{bubble.size} nor \code{bubble.col} is specified, no bubble map is drawn. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{bubble.col}{name of the data variable in \code{shp} for the bubble map that specifies the colors of the bubbles. If neither \code{bubble.size} nor \code{bubble.col} is specified, no bubble map is drawn. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{text}{Name of the data variable that contains the text labels. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{text.size}{Font size of the text labels. Either a constant value, or the name of a numeric data variable. Only applicable when \code{shp} is type 1, 2, or 3 (see above).}

\item{line.lwd}{either a line width or a name of the data variable that specifies the line width. Only applicable when \code{shp} is type 3 (see above).}

\item{line.col}{either a line color or a name of the data variable that specifies the line colors. Only applicable when \code{shp} is type 3 (see above).}

\item{raster}{either a color or a name of the data variable that specifices the raster colors. Only applicable when \code{shp} is type 4, 5, or 6 (see above).}

\item{borders}{color of the polygon borders. Use \code{NA} to omit the borders.}

\item{theme}{one of "World", "Europe", "NLD", "World_wide", "Europe_wide", "NLD_wide"}

\item{scale}{numeric value that serves as the global scale parameter. All font sizes, bubble sizes, border widths, and line widths are controled by this value. The parameters \code{bubble.size}, \code{text.size}, and \code{line.lwd} can be scaled seperately with respectively \code{bubble.scale}, \code{text.scale}, and \code{line.scale}.}

\item{title}{main title. For legend titles, use \code{X.style}, where X is layer name (see \code{...}).}

\item{...}{arguments passed on to the \code{tm_*} functions. If an argument name is not unique for a particular \code{tm_} function, then it should be prefixed with the function name without \code{"tm_"}. For instance, \code{style} is an argument of \code{\link{tm_fill}}, \code{\link{tm_bubbles}}, and \code{\link{tm_lines}}. Therefore, in order to define the \code{style} for a choropleth, its arugment name should be \code{fill.style}.}
}
\value{
\code{\link{tmap-element}}
}
\description{
Draw a thematic map quickly.
}
\details{
This function is a convenient wrapper of the main plotting method of stacking \code{\link{tmap-element}}s. The first argument is a shape object (normally specified by \code{\link{tm_shape}}). The next arguments, from \code{fill} to \code{raster}, are the aesthetics from the main layers. The remaining arguments are related to the map layout. Any argument from any main layer can be specified (see \code{...}). It is also possible to stack \code{\link{tmap-element}}s on a \code{qtm} plot. See examples.
}
\examples{
data(Europe)
data(World)
data(metro)

# just the map
qtm(Europe)

# choropleth
qtm(World, fill = "economy", text="iso_a3", text.size = "AREA", 
    fill.palette="-Blues", theme = "World", fill.title="Economy")

qtm(Europe, fill="gdp_cap_est", text="iso_a3", text.size="pop_est", 
    fill.title="GDP per capita", fill.textNA="Non-European countries")

qtm(World, fill="pop_est_dens", theme="World", fill.style="kmeans", fill.title="Population per km")

# bubble map
qtm(World, borders = NA) + qtm(metro, bubble.size = "pop2010", bubble.col="purple", 
    bubble.title.size="Metropolitan Areas", theme = "World", bubble.scale=.5)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

