% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tm_layers.R
\name{tm_lines}
\alias{tm_lines}
\title{Draw spatial lines}
\usage{
tm_lines(col = "red", lwd = 1, lty = "solid", alpha = NA, scale = 1,
  n = 5, style = "pretty", breaks = NULL, palette = NULL,
  labels = NULL, auto.palette.mapping = TRUE, contrast = 1,
  max.categories = 12, colorNA = "grey65", textNA = "Missing",
  text_separator = "to", text_less_than = "Less than",
  text_or_more = "or more", title.col = NA, title.lwd = NA,
  legend.col.is.portrait = TRUE, legend.lwd.is.portrait = FALSE,
  legend.hist = FALSE, legend.hist.title = NA, legend.col.z = NA,
  legend.lwd.z = NA, legend.hist.z = NA)
}
\arguments{
\item{col}{color of the lines. Either a color value or a data variable name.}

\item{lwd}{line width}

\item{lty}{line type}

\item{alpha}{transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{col} is used (normally 1).}

\item{scale}{line width multiplier number.}

\item{n}{preferred number of color scale classes. Only applicable when \code{lwd} is the name of a numeric variable.}

\item{style}{method to cut the color scale: e.g. "fixed", "equal", "pretty", "quantile", or "kmeans". See the details in \code{\link[classInt:classIntervals]{classIntervals}}. Only applicable when \code{lwd} is the name of a numeric variable.}

\item{breaks}{in case \code{style=="fixed"}, breaks should be specified}

\item{palette}{color palette (see \code{RColorBrewer::display.brewer.all}) for the lines. Only when \code{col} is set to a variable.}

\item{labels}{labels of the classes}

\item{auto.palette.mapping}{When diverging colour palettes are used (i.e. "RdBu") this method automatically maps colors to values such that the middle colors (mostly white or yellow) are assigned to values of 0, and the two sides of the color palette are assigned to negative respectively positive values. In this case of line widths, obviously only the positive side is used.}

\item{contrast}{vector of two numbers that determine the range that is used for sequential and diverging palettes (applicable when \code{auto.palette.mapping=TRUE}). Both numbers should be between 0 and 1. The first number determines where the palette begins, and the second number where it ends. For sequential palettes, 0 means the brightest color, and 1 the darkest color. For diverging palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}

\item{max.categories}{in case \code{col} is the name of a categorical variable, this value determines how many categories (levels) it can have maximally. If the number of levels is higher than \code{max.categories}, then levels are combined.}

\item{colorNA}{color used for missing values}

\item{textNA}{text used for missing values. Use \code{NA} to omit text for missing values in the legend}

\item{text_separator}{Character string to use to separate numbers in the legend (default: "to").}

\item{text_less_than}{Character string to use to translate "Less than" (which is the default).}

\item{text_or_more}{Character string to use to translate "or more" (which is the default).}

\item{title.col}{title of the legend element regarding the line colors}

\item{title.lwd}{title of the legend element regarding the line widths}

\item{legend.col.is.portrait}{logical that determines whether the legend element regarding the line colors is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.lwd.is.portrait}{logical that determines whether the legend element regarding the line widths is in portrait mode (\code{TRUE}) or landscape (\code{FALSE})}

\item{legend.hist}{logical that determines whether a histogram is shown regarding the line colors}

\item{legend.hist.title}{title for the histogram. By default, one title is used for both the histogram and the normal legend for line colors.}

\item{legend.col.z}{index value that determines the position of the legend element regarding the line colors with respect to other legend elements. The legend elements are stacked according to their z values. The legend element with the lowest z value is placed on top.}

\item{legend.lwd.z}{index value that determines the position of the legend element regarding the line widths. (See \code{legend.col.z})}

\item{legend.hist.z}{index value that determines the position of the legend element regarding the histogram. (See \code{legend.col.z})}
}
\value{
\code{\link{tmap-element}}
}
\description{
Creates a \code{\link{tmap-element}} that draw spatial lines.
}
\examples{
data(rivers)
data(World)
data(Europe)

tm_shape(World) +
  tm_fill("darkolivegreen3") +
tm_shape(rivers) +
  tm_lines(col="navy") +
tm_layout_World("Rivers of the World", inner.margins = c(0,0,.1,0))

tm_shape(Europe) +
  tm_fill("darkolivegreen3") +
  tm_borders("white") +
tm_shape(rivers) +
  tm_lines(col="navy", lwd="scalerank", scale=2) +
tm_layout("Rivers of Europe", legend.show=FALSE)
}
\seealso{
\href{../doc/tmap-nutshell.html}{\code{vignette("tmap-nutshell")}}
}

