% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{renderTmap}
\alias{renderTmap}
\alias{tmapOutput}
\alias{tmapProxy}
\alias{tm_remove_layer}
\title{Wrapper functions for using tmap in shiny}
\usage{
renderTmap(expr, env = parent.frame(), quoted = FALSE)

tmapOutput(outputId, width = "100\%", height = 400)

tmapProxy(mapId, session = shiny::getDefaultReactiveDomain(), x)

tm_remove_layer(zindex)
}
\arguments{
\item{expr}{A tmap object. A tmap object is created with \code{\link{qtm}} or by stacking \code{\link{tmap-element}}s.}

\item{env}{The environment in which to evaluate expr}

\item{quoted}{Is expr a quoted expression (with quote())? This is useful if you want to save an expression in a variable}

\item{outputId}{Output variable to read from}

\item{width, height}{the width and height of the map}

\item{mapId}{single-element character vector indicating the output ID of the map to modify (if invoked from a Shiny module, the namespace will be added automatically)}

\item{session}{the Shiny session object to which the map belongs; usually the default value will suffice}

\item{x}{the tmap object that specifies the added and removed layers.}

\item{zindex}{the z index of the pane in which the layer is contained that is going to be removed. It is recommended to specify the zindex for this layer when creating the map (inside \code{renderTmap}).}
}
\description{
Use \code{tmapOutput} to create a UI element, and \code{renderTmap} to render the tmap map. To update the map (more specifically, to add and remove layers) use \code{tmapProxy}. Adding layers is as usual, removing layers can be done with the function \code{tm_remove_layer}.
}
\details{
Two features from tmap are not (yet) supported in Shiny: small multiples (facets) and colored backgrounds (argument bg.color of \code{\link{tm_layout}}). Workarounds for small multiples: create multiple independent maps or specify as.layers = TRUE in \code{\link{tm_facets}}.
}
\examples{
if (require("shiny")) {
	
	
	data(World)
	world_vars <- setdiff(names(World), c("iso_a3", "name", "sovereignt", "geometry"))
	
	
	ui <- fluidPage(
		tmapOutput("map"),
		selectInput("var", "Variable", world_vars)
	)
	
	server <- function(input, output, session) {
		output$map <- renderTmap({
			tm_shape(World) +
				tm_polygons(world_vars[1], zindex = 401)
		})
		
		observe({
			var <- input$var
			tmapProxy("map", session, {
				tm_remove_layer(401) +
				tm_shape(World) +
					tm_polygons(var, zindex = 401)
			})
		})
	}	
	
	
	app <- shinyApp(ui, server)
	if (interactive()) app
}
}
