% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_mode.R
\name{tmap_mode}
\alias{tmap_mode}
\alias{ttm}
\alias{ttmp}
\title{Set tmap mode to static plotting or interactive viewing}
\usage{
tmap_mode(mode = NULL)

ttm()

ttmp()
}
\arguments{
\item{mode}{One of \code{"plot"} or \code{"view"}. See Details for more info.}
}
\value{
\itemize{
\item \code{tmap_mode()} returns the current tmap mode invisibly (when called without argument).
Otherwise, returns the previous mode.
\item \code{ttm()} switches mode and returns previous tmap mode invisibly.
The previous tmap mode before switching.
}
}
\description{
\itemize{
\item \code{tmap_mode()} informs of the current mode (if called without argument).
\item \code{ttm()} switches mode automatically.
\item \code{ttmp()} switches mode and calls \code{\link[=tmap_last]{tmap_last()}} to display the last map in the other mode.
}

Set tmap mode to static plotting or interactive viewing.
The global option \code{tmap.mode} determines the whether thematic maps are plot
in the graphics device, or shown as an interactive leaflet map (see also \code{\link[=tmap_options]{tmap_options()}}.
The function \code{tmap_mode()} is a wrapper to set this global option.
The convenient function \code{ttm()}, which stands for toggle thematic map,
is a toggle switch between the two modes. The function \code{ttmp()} stands for
toggle thematic map and print last map: it does the same as \code{ttm()} followed
by \code{\link[=tmap_last]{tmap_last()}}; in order words, it shows the last map in the other mode.
It is recommended to use \code{tmap_mode()} in scripts and \code{ttm()}/\code{ttmp()} in the console.
}
\section{\code{mode = "plot"}}{
Thematic maps are shown in the graphics device.
This is the default mode, and supports all tmap's features,
such as small multiples (see \code{\link[=tm_facets]{tm_facets()}}) and extensive layout settings (see \code{\link[=tm_layout]{tm_layout()}}).
It is recommended to use \code{\link[=tmap_save]{tmap_save()}} for saving static maps.
}

\section{\code{mode = "view"}}{
Thematic maps are viewed interactively in the web browser or RStudio's Viewer pane.
Maps are fully interactive with tiles from OpenStreetMap or other map providers
(see \code{\link[=tm_tiles]{tm_tiles()}}). See also \code{\link[=tm_view]{tm_view()}} for options related to the \code{"view"} mode.
This mode generates a \code{\link[leaflet:leaflet]{leaflet::leaflet()}} widget, which can also be directly
obtained with \code{\link[=tmap_leaflet]{tmap_leaflet()}}.
With R Markdown, it is possible to publish it to an HTML page.

However, there are a couple of constraints in comparison to \code{"plot"}:
}

\examples{
current.mode = tmap_mode()

tmap_mode("plot")

tm_shape(World) + tm_polygons("HPI")

tmap_mode("view")

tm_shape(World) + tm_polygons("HPI")

ttm()

tm_shape(World) + tm_polygons("HPI")

tmap_mode(current.mode)
}
\references{
Tennekes, M., 2018, {tmap}: Thematic Maps in {R},
Journal of Statistical Software, 84(6), 1-39, \doi{10.18637/jss.v084.i06}
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_modes}{vignette about modes}
\itemize{
\item \code{\link[=tmap_last]{tmap_last()}} to show the last map
\item \code{\link[=tm_view]{tm_view()}} for viewing options
\item \code{\link[=tmap_leaflet]{tmap_leaflet()}} for obtaining a leaflet widget
\item \code{\link[=tmap_options]{tmap_options()}} for tmap options
}
}
