% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmlenet.R
\name{tmlenet}
\alias{tmlenet}
\title{Estimate Average Network Effects For Arbitrary (Stochastic) Interventions}
\usage{
tmlenet(DatNet.ObsP0, data, Kmax, sW, sA, Anode, Ynode, f_gstar1,
  Qform = NULL, hform.g0 = NULL, hform.gstar = NULL, NETIDmat = NULL,
  IDnode = NULL, NETIDnode = NULL, verbose = getOption("tmlenet.verbose"),
  optPars = list(alpha = 0.05, lbound = 0.005, family = "binomial", n_MCsims =
  10, runTMLE = c("tmle.intercept", "tmle.covariate"), YnodeDET = NULL, f_gstar2
  = NULL, sep = " ", f_g0 = NULL, h_g0_SummariesModel = NULL,
  h_gstar_SummariesModel = NULL))
}
\arguments{
\item{DatNet.ObsP0}{Instance of class \code{\link{DatNet.sWsA}} returned under the same name by the \code{\link{eval.summaries}} function.
Stores the evaluated summary measures (\code{sW},\code{sA}) for the observed data, along with the network information.
When this argument is specified, the
following arguments no longer need to be provided: \code{data}, \code{Kmax}, \code{sW}, \code{sA},
\code{IDnode}, \code{NETIDnode}, \code{optPars$sep}, \code{NETIDmat}.}

\item{data}{Observed data, a \code{data.frame} with named columns, containing the baseline covariates,
exposures (\code{Anode}), the outcomes (\code{Ynode}) and possibly the network column (\code{NETIDnode}), where
network is specified by a vector of strings of friend IDs, each string using \code{optPars$sep} character to separate different friend IDs
(default is \code{optPars$sep=' '}).}

\item{Kmax}{Integer constant specifying the maximal number of friends for any observation in the input \code{data} data.frame.}

\item{sW}{Summary measures constructed from baseline covariates alone. This must be an object of class
\code{DefineSummariesClass} that is returned by calling the function \code{\link{def.sW}}.}

\item{sA}{Summary measures constructed from exposures \code{Anode} and baseline covariates. This must be an object of class
\code{DefineSummariesClass} that is returned by calling the function \code{\link{def.sW}}.}

\item{Anode}{Exposure (treatment) variable name (column name in \code{data}); exposures can be either binary, categorical or continuous.}

\item{Ynode}{Outcome variable name (column name in \code{data}), assumed normalized between 0 and 1. This can instead be specified
on the left-side of the regression formula in argument \code{Qform}.}

\item{f_gstar1}{Either a function or a vector of counterfactual exposures. If a function, must return
a vector of counterfactual exposures evaluated based on the summary measures matrix (\code{sW,sA}) passed as a named
argument \code{"data"}, therefore, the function in \code{f_gstar1} must have a named argument \code{"data"} in its signature.
The interventions defined by \code{f_gstar1} can be static, dynamic or stochastic. If \code{f_gstar1} is specified as a
vector, it must be of length \code{nrow(data)} or 1 (constant treatment assigned to all observations).
See Details below and Examples in "EQUIVALENT WAYS OF SPECIFYING INTERVENTION \code{f_gstar1}" for demonstration.}

\item{Qform}{Regression formula for outcome in \code{Ynode}, when omitted (\code{Ynode}=\code{NULL}), the outcome variable is
regressed on all variables defined in \code{sW} and \code{sA}. See Details.}

\item{hform.g0}{Regression formula for estimating the conditional density of P(\code{sA} | \code{sW}) under \code{g0}
(the observed exposure mechanism), when omitted, this regression is defined by \code{sA~sW} where \code{sA}
are all summary measures defined by argument \code{sA} and \code{sW} are all baseline summary measures defined by argument \code{sW}.}

\item{hform.gstar}{Regression formula for estimating the conditional density P(\code{sA} | \code{sW}) under interventions
\code{f_gstar1} or \code{f_gstar2}.
When omitted, the same regression formula as in \code{hform.g0} will be used for \code{hform.gstar}. See Details.}

\item{NETIDmat}{Network specification via matrix of friend IDs (\code{ncol=Kmax}, \code{nrow=nrow(data)}),
where each row \code{i} is a vector of \code{i}'s friends IDs or \code{i}'s friends row
numbers in \code{data} if \code{IDnode=NULL}. See Details.}

\item{IDnode}{Subject identifier variable in the input data, if not supplied the network string in
\code{NETIDnode} is assumed to be indexing the row numbers in the input \code{data}}

\item{NETIDnode}{Network specification by a column name in input \code{data} consisting of strings that identify the unit's friends
by their IDs or their row numbers (two friends are separated by space, e.g., \code{"1 2"}; unit with no friends should have
an empty \code{""} string). See Details.}

\item{verbose}{Set to \code{TRUE} to print messages on status and information to the console.
Turn this on by default using \code{options(tmlenet.verbose=TRUE)}.}

\item{optPars}{A named list of additional optional parameters to be passed to \code{tmlenet}, such as
 \code{alpha}, \code{lbound}, \code{family}, \code{n_MCsims}, \code{runTMLE}, \code{YnodeDET}, \code{f_gstar2}, \code{sep},
 \code{f_g0}, \code{h_g0_SummariesModel} and
 \code{h_gstar_SummariesModel}. See Details below for the description of each parameter.}
}
\value{
A named list with 3 items containing the estimation results for:
 \itemize{
 \item \code{EY_gstar1} - estimates of the mean counterfactual outcome under (stochastic) intervention function \code{f_gstar1} \eqn{(E_{g^*_1}[Y])}.
 \item \code{EY_gstar2} - estimates of the mean counterfactual outcome under (stochastic) intervention function \code{f_gstar2} \eqn{(E_{g^*_2}[Y])},
   \code{NULL} if \code{f_gstar2} not specified.
 \item \code{ATE} - additive treatment effect (\eqn{E_{g^*_1}[Y]} - \eqn{E_{g^*_2}[Y]}) under interventions \code{f_gstar1}
   vs. in \code{f_gstar2}, \code{NULL} if \code{f_gstar2} not specified.
}

Each list item above is itself a list containing the items:
 \itemize{
 \item \code{estimates} - various estimates of the target parameter (network population counterfactual mean under
   (stochastic) intervention).
 \item \code{vars} - the asymptotic variance estimates, for \strong{IPTW} and \strong{TMLE}.
 \item \code{CIs} - CI estimates at \code{alpha} level, for \strong{IPTW} and \strong{TMLE}.
 \item \code{other.vars} - Placeholder for future versions.
 \item \code{h_g0_SummariesModel} - The model fits for P(\code{sA}|\code{sW}) under observed exposure mechanism
   \code{g0}. This is an object of \code{SummariesModel} \pkg{R6} class.
 \item \code{h_gstar_SummariesModel} - The model fits for P(\code{sA}|\code{sW}) under intervention \code{f_gstar1}
   or \code{f_gstar2}. This is an object of \code{SummariesModel} \pkg{R6} class.
}

Currently implemented estimators are:
 \itemize{
 \item \code{tmle} - Either weighted regression intercept-based TMLE (\code{tmle.intercept} - the default)
   with weights defined by the IPTW weights \code{h_gstar/h_gN} or
   covariate-based unweighted TMLE (\code{tmle.covariate}) that uses the IPTW weights as a covariate
   \code{h_gstar/h_gN}.
 \item \code{h_iptw} - Efficient IPTW based on weights h_gstar/h_gN.
 \item \code{gcomp} - Parametric G-computation formula substitution estimator.
}
}
\description{
Estimate the average network effect among dependent units with known network structure (in presence of
 interference and/or spillover) using \strong{TMLE} (targeted maximum likelihood estimation), \strong{IPTW}
 (Horvitz-Thompson or the inverse-probability-of-treatment) and \strong{GCOMP} (parametric G-computation formula).
}
\section{Details}{



Note that in case when both arguments \code{NETIDnode} and \code{NETIDmat} are left unspecified the input data are
 assumed independent, i.e., no network dependency between the observations.
 All inference will be performed based on the i.i.d. efficient influence curve for the target
 parameter \eqn{(E_{g^*_1}[Y])}.

Also note that the ordering of the friends IDs in \code{NETIDnode} or \code{NETIDmat} is unimportant.

A special non-negative-integer-valued variable \code{nF} is automatically calculated each time
 \code{tmlenet} or \code{eval.summaries} functions are called. \code{nF} contains the total number of friends for
 each observation and it is always added as an additional column to the matrix of the baseline-covariates-based
 summary measures \code{sWmat}. The variable \code{nF} can be used in the same ways as any of the column names in
 the input data frame \code{data}. In particular, the name \code{nF} can be used inside the summary measure
 expressions (calls to functions \code{def.sW} and \code{def.sA}) and inside any of the regression formulas
 (\code{Qform}, \code{hform.g0}, \code{hform.gstar}).

The regression formalas in \code{Qform}, \code{hform.g0} and \code{hform.gstar} can include any summary measures names defined in
 \code{sW} and \code{sA}, referenced by their individual variable names or by their aggregate summary measure names.
 For example, \code{hform.g0 = "netA ~ netW"} is equivalent to
 \code{hform.g0 = "A + A_netF1 + A_netF2 ~ W + W_netF1 + W_netF2"} for \code{sW,sA} summary measures defined by
 \code{def.sW(netW=W[[0:2]])} and \code{def.sA(netA=A[[0:2]])}.
}

\section{Additional parameters}{


Some of the parameters that control the estimation in \code{tmlenet} can be set by calling the function
 \code{\link{tmlenet_options}}.

Additional parameters can be also specified as a named list \code{optPars} argument of the
\code{tmlenet} function. The items that can be specified in \code{optPars} are:
\itemize{

\item \code{alpha} - alpha-level for CI calculation (0.05 for 95% CIs);

\item \code{lbound} - One value for symmetrical bounds on P(sW | sW).

\item \code{family} - Family specification for regression models, defaults to binomial (CURRENTLY ONLY BINOMIAL
 FAMILY IS IMPLEMENTED).

\item \code{n_MCsims} - Number of Monte-Carlo simulations performed, each of sample size \code{nrow(data)},
   for generating new exposures under \code{f_gstar1} or \code{f_gstar2} (if specified) or \code{f_g0} (if specified).
   These newly generated exposures are utilized when fitting the conditional densities P(\code{sA}|\code{sW})
   and when evaluating the substitution estimators \strong{GCOMP} and \strong{TMLE}
   under stochastic interventions \code{f_gstar1} or \code{f_gstar2}.

\item \code{runTMLE} - Choose which of the two TMLEs to run, "tmle.intercept" or "tmle.covariate". The default is "tmle.intercept".

\item \code{YnodeDET} - Optional column name for indicators of deterministic values of outcome \code{Ynode},
   coded as (\code{TRUE}/\code{FALSE}) or
   (\code{1}/\code{0}); observations with \code{YnodeDET}=\code{TRUE}/\code{1} are assumed to have constant value for their \code{Ynode}.

\item \code{f_gstar2} - Either a function or a vector of counterfactual exposure assignments.
   Used for estimating contrasts (average treatment effect) for two interventions, if omitted, only the average
   counterfactual outcome under intervention \code{f_gstar1} is estimated. The requirements for \code{f_gstar2}
   are identical to those for \code{f_gstar1}.

\item \code{sep} - A character separating friend indices for the same observation in \code{NETIDnode}.

\item \code{f_g0} - A function for generating true treatment mechanism under observed \code{Anode}, if known (for example in a
   randomized trial). This is used for estimating P(\code{sA}|\code{sW}) under \code{g0} by sampling large vector of \code{Anode}
   (of length \code{nrow(data)*n_MCsims}) from \code{f_g0} function;

\item \code{h_g0_SummariesModel} - Previously fitted model for P(\code{sA}|\code{sW}) under observed exposure mechanism \code{g0},
   returned by the previous runs of the \code{tmlenet} function.
   This has to be an object of \code{SummariesModel} \pkg{R6} class. When this argument is specified, all predictions
   P(\code{sA}=\code{sa}|\code{sW}=\code{sw}) under \code{g0} will be based on the model fits provided by this argument.

\item \code{h_gstar_SummariesModel} - Previously fitted model for P(\code{sA}|\code{sW}) under (stochastic) intervention
   specified by \code{f_gstar1} or \code{f_gstar2}. Also an object of \code{SummariesModel} \pkg{R6} class.
   When this argument is specified, the predictions P(\code{sA}=\code{sa}|\code{sW}=\code{sw})
   under \code{f_gstar1} or \code{f_gstar2} will be based on the model fits provided by this argument.
}
}

\section{Specifying the counterfactual intervention function (\code{f_gstar1} and \code{optPars$f_gstar2})}{


The functions \code{f_gstar1} and \code{f_gstar2} can only depend on variables specified by the combined matrix
 of summary measures (\code{sW},\code{sA}), which is passed using the argument \code{data}. The functions should
 return a vector of length \code{nrow(data)} of counterfactual treatments for observations in the input data.
}

\section{Specifying the Network of Friends}{


The network of friends (connections) for observations in the input \code{data} can be specified in two
 alternative ways, using either \code{NETIDnode} or \code{NETIDmat} input arguments.

\code{NETIDnode} - The first (slower) method uses a vector of strings in \code{data[, NETIDnode]}, where each
 string \code{i} must contain the space separated IDs or row numbers of all units in \code{data} thought to be
 connected to observation i (friends of unit i);

\code{NETIDmat} - An alternative (and faster) method is to pass a matrix with \code{Kmax} columns and nrow(data)
 rows, where each row \code{NETIDmat[i,]} is a vector of observation \code{i}'s friends' IDs or \code{i}'s friends'
 row numbers in \code{data} if \code{IDnode=NULL}. If observation \code{i} has fewer than \code{Kmax} friends, the
 remainder of \code{NETIDmat[i,]} must be filled with \code{NA}s. Note that the ordering of friend indices is
 irrelevant.
}

\section{IPTW estimator}{

**********************************************************************

\itemize{
\item As described in the following section, the first step is to construct an estimator \eqn{P_{g_N}(sA | sW)}
   for the common (in \code{i}) conditional density \eqn{P_{g_0}(sA | sW)} for common (in \code{i}) unit-level summary
   measures (\code{sA},\code{sW}).

\item The same fitting algorithm is applied to construct an estimator \eqn{P_{g^*_N}(sA^* | sW^*)} of the common (in \code{i})
   conditional density \eqn{P_{g^*}(sA^* | sW^*)} for common (in \code{i}) unit-level summary measures (\code{sA^*},\code{sW^*})
   implied by the user-supplied stochastic intervention \code{f_gstar1} or \code{f_gstar2} and the observed distribution of \code{W}.

\item These two density estimators form the basis of the IPTW estimator,
   which is evaluated at the observed N data points \eqn{O_i=(sW_i, sA_i, Y_i), i=1,...,N} and is given by
   \deqn{\psi^{IPTW}_n = \sum_{i=1,...,N}{Y_i \frac{P_{g^*_N}(sA^*=sA_i | sW=sW_i)}{P_{g_N}(sA=sA_i | sW=sW_i)}}.}
}
}

\section{GCOMP estimator}{

**********************************************************************
}

\section{TMLE estimator}{

**********************************************************************
}

\section{Modeling \code{P(sA|sW)} for summary measures \code{(sA,sW)}}{

**********************************************************************

Non-parametric
 estimation of the common \strong{unit-level} multivariate joint conditional probability model \code{P_g0(sA|sW)},
 for unit-level summary measures \code{(sA,sW)} generated from the observed exposures and baseline covariates
 \eqn{(A,W)=(A_i,W_i : i=1,...,N)} (their joint density given by \eqn{g_0(A|W)Q(W)}), is performed by first
 constructing the dataset of N summary measures, \eqn{(sA_i,sW_i : i=1,...,N)}, and then fitting the usual i.i.d. MLE
 for the common density \code{P_g0(sA|sW)} based on the pooled N sample of these summary measures.

 Note that \code{sA} can be multivariate and any of its components \code{sA[j]} can be either binary, categorical
 or continuous.
 The joint probability model for \code{P(sA|sA)} = \code{P(sA[1],...,sA[k]|sA)} can be factorized as
 \code{P(sA[1]|sA)} * \code{P(sA[2]|sA, sA[1])} * ... * \code{P(sA[k]|sA, sA[1],...,sA[k-1])},
 where each of these conditional probability models is fit separately, depending on the type of the outcome variable
 \code{sA[j]}.

 If \code{sA[j]} is binary, the conditional probability \code{P(sA[j]|sW,sA[1],...,sA[j-1])} is evaluated via logistic
 regression model.
 When \code{sA[j]} is continuous (or categorical), its range will be fist partitioned into \code{K} bins and the
 corresponding \code{K}
 bin indicators (\code{B_1,...,B_K}), where each bin indicator \code{B_j} is then used as an outcome in a
 separate logistic regression model with predictors given by \code{sW, sA[1],...,sA[k-1]}.
 Thus, the joint probability \code{P(sA|sW)} is defined by such a tree of binary logistic regressions.

For simplicity, we now suppose \code{sA} is continuous and univariate and we describe here an algorithm for fitting
 \eqn{P_{g_0}(sA | sW)} (the algorithm
 for fitting \eqn{P_{g^*}(sA^* | sW^*)} is equivalent, except that exposure \code{A} is replaced with exposure \code{A^*}
 generated under \code{f_gstar1} or \code{f_gstar2} and
 the predictors \code{sW} from the regression formula \code{hform.g0} are replaced with predictors \code{sW^*}
 specified by the regression formula \code{hform.gstar}).

\enumerate{
\item Generate a dataset of N observed continuous summary measures (\code{sa_i}:i=1,...,N) from observed
 ((\code{a_i},\code{w_i}):i=1,...,N). Let \code{sa}\\in{\code{sa_i}:i=1,...,M}.

\item Divide the range of \code{sA} values into intervals S=(i_1,...,i_M,i_{M+1}) so that any observed data point
   \code{sa_i} belongs to one interval in S, namely,
   for each possible value sa of \code{sA} there is k\\in{1,...,M}, such that, i_k < \code{sa} <= i_{k+1}.
   Let the mapping B(sa)\\in{1,...,M} denote a unique interval in S for sa, such that, i_{B(sa)} < sa <= i_{B(sa)+1}.
   Let bw_{B(sa)}:=i_{B(sa)+1}-i_{B(sa)} be the length of the interval (bandwidth) (i_{B(sa)},i_{B(sa)+1}).
   Also define the binary indicators b_1,...,b_M, where b_j:=I(B(sa)=j), for all j <= B(sa) and b_j:=NA for all j>B(sa).
   That is we set b_j to missing ones the indicator I(B(sa)=j) jumps from 0 to 1.
   Now let \code{sA} denote the random variable for the observed summary measure for one unit
   and denote by (B_1,...,B_M) the corresponding random indicators for \code{sA} defined as B_j := I(B(\code{sA}) = j)
   for all j <= B(\code{sA}) and B_j:=NA for all j>B(\code{sA}).

\item For each j=1,...,M, fit the logistic regression model for the conditional probability P(B_j = 1 | B_{j-1}=0, sW), i.e.,
   at each j this is defined as the conditional probability of B_j jumping from 0 to 1 at bin j, given that B_{j-1}=0 and
   each of these logistic regression models is fit only among the observations that are still at risk of having B_j=1 with B_{j-1}=0.

\item Normalize the above conditional probability of B_j jumping from 0 to 1 by its corresponding interval length (bandwidth) bw_j to
   obtain the discrete conditional hazards h_j(sW):=P(B_j = 1 | (B_{j-1}=0, sW) / bw_j, for each j.
   For the summary measure \code{sA}, the above conditional hazard h_j(sW) is equal to P(\code{sA} \\in (i_j,i_{j+1}) | \code{sA}>=i_j, sW),
   i.e., this is the probability that \code{sA} falls in the interval (i_j,i_{j+1}), conditional on sW and conditional on the fact that
   \code{sA} does not belong to any intervals before j.

\item  Finally, for any given data-point \code{(sa,sw)}, evaluate the discretized conditional density for P(\code{sA}=sa|sW=sw) by first
   evaluating the interval number k=B(sa)\\in{1,...,M} for \code{sa} and then computing \\prod{j=1,...,k-1}{1-h_j(sW))*h_k(sW)}
   which is equivalent to the joint conditional probability that \code{sa} belongs to the interval (i_k,i_{k+1}) and does not belong
   to any of the intervals 1 to k-1, conditional on sW.
 }

The evaluation above utilizes a discretization of the fact that any continuous density f of random variable X can be written as f_X(x)=S_X(x)*h_X(x),
 for a continuous density f of X where S_X(x):=P(X>x) is the survival function for X, h_X=P(X>x|X>=x) is the hazard function for X; as well as the fact that
 the discretized survival function S_X(x) can be written as a of the hazards for s<x: S_X(x)=\\prod{s<x}h_X(x).
}

\section{Three methods for defining bin (interval) cuttoffs for a continuous one-dimenstional summary measure \code{sA[j]}}{

**********************************************************************

There are 3 alternative methods to defining the bin cutoffs S=(i_1,...,i_M,i_{M+1}) for a continuous summary measure
 \code{sA}. The choice of which method is used along with other discretization parameters (e.g., total number of
 bins) is controlled via the tmlenet_options() function. See \code{?tmlenet_options} argument \code{bin.method} for
 additional details.

Approach 1 (\code{equal.len}): equal length, default.

*********************

The bins are defined by splitting the range of observed \code{sA} (sa_1,...,sa_n) into equal length intervals.
 This is the dafault discretization method, set by passing an argument \code{bin.method="equal.len"} to
 \code{tmlenet_options} function prior to calling \code{tmlenet()}. The intervals will be defined by splitting the
 range of (sa_1,...,sa_N) into \code{nbins} number of equal length intervals, where \code{nbins} is another argument
 of \code{tmlenet_options()} function. When \code{nbins=NA} (the default setting) the actual value of \code{nbins}
 is computed at run time by taking the integer value (floor) of \code{n/maxNperBin},
 for \code{n} - the total observed sample size and \code{maxNperBin=1000} - another argument of
 \code{tmlenet_options()} with the default value 1,000.

Approach 2 (\code{equal.mass}): data-adaptive equal mass intervals.

*********************

The intervals are defined by splitting the range of \code{sA} into non-equal length data-adaptive intervals that
 ensures that each interval contains around
 \code{maxNperBin} observations from (sa_j:j=1,...,N).
 This interval definition approach can be selected by passing an argument \code{bin.method="equal.mass"} to
 \code{tmlenet_options()} prior to calling \code{tmlenet()}.
 The method ensures that an approximately equal number of observations will belong to each interval, where that number
 of observations for each interval
 is controlled by setting \code{maxNperBin}. The default setting is \code{maxNperBin=1000} observations per interval.

Approach 3 (\code{dhist}): combination of 1 & 2.

*********************

The data-adaptive approach dhist is a mix of Approaches 1 & 2. See Denby and Mallows "Variations on the Histogram"
 (2009)). This interval definition method is selected by passing an argument \code{bin.method="dhist"} to
 \code{tmlenet_options()}  prior to calling \code{tmlenet()}.
}
\examples{
#***************************************************************************************
data(df_netKmax6) # Load observed data
data(NetInd_mat_Kmax6) # Load the network ID matrix
Kmax <- 6 # Max number of friends in the network
#***************************************************************************************

#***************************************************************************************
# EXAMPLES OF INTERVENTION FUNCTIONS:
#***************************************************************************************
# Returns a function that will sample A with probability x:=P(A=1))
make_f.gstar <- function(x, ...) {
  eval(x)
  f.A_x <- function(data, ...){
    rbinom(n = nrow(data), size = 1, prob = x[1])
  }
  return(f.A_x)
}
# Deterministic f_gstar setting every A=0:
f.A_0 <- make_f.gstar(x = 0)
# Deterministic f_gstar setting every A=1:
f.A_1 <- make_f.gstar(x = 1)
# Stochastically sets (100*x)\% of population to A=1 with probability 0.2:
f.A_.2 <- make_f.gstar(x = 0.2)

#***************************************************************************************
# DEFINING SUMMARY MEASURES:
#***************************************************************************************
def_sW <- def.sW(netW2 = W2[[1:Kmax]]) +
          def.sW(sum.netW3 = sum(W3[[1:Kmax]]), replaceNAw0=TRUE)

def_sA <- def.sA(sum.netAW2 = sum((1-A[[1:Kmax]])*W2[[1:Kmax]]), replaceNAw0=TRUE) +
          def.sA(netA = A[[0:Kmax]])

#***************************************************************************************
# EVALUATING SUMMARY MEASURES BASED ON INPUT DATA:
#***************************************************************************************
# A helper function that can pre-evaluate the summary measures on (O)bserved data, 
# given one of two ways of specifying the network:
res <- eval.summaries(sW = def_sW, sA = def_sA,  Kmax = 6, data = df_netKmax6,
                      NETIDmat = NetInd_mat_Kmax6, verbose = TRUE)

#***************************************************************************************
# Specifying the clever covariate regressions hform.g0 and hform.gstar:
# Left side can consist of any summary names defined by def.sA (as linear terms)
# Right side can consist of any summary names defined by def.sW (as linear terms) & 'nF'
#***************************************************************************************
hform.g01 <- "netA ~ netW2 + sum.netW3 + nF"
hform.gstar1 <- "netA ~ sum.netW3"

# alternatives:
hform.g02 <- "netA + sum.netAW2 ~ netW2 + sum.netW3 + nF"
hform.g03 <- "sum.netAW2 ~ netW2 + sum.netW3"

#***************************************************************************************
# Specifying the outcome regression Qform:
# Left side is ignored (with a warning if not equal to Ynode)
# Right side can by any summary names defined by def.sW, def.sA & 'nF'
#***************************************************************************************
Qform1 <- "Y ~ sum.netW3 + sum.netAW2"
Qform2 <- "Y ~ netA + netW + nF"
Qform3 <- "blah ~ netA + netW + nF"

#***************************************************************************************
# Estimate mean population outcome under deterministic intervention A=0 with 6 friends:
# Estimation with regression formulas.
#***************************************************************************************
# Note that Ynode is optional when Qform is specified;
options(tmlenet.verbose = FALSE) # set to TRUE to print status messages
res_K6_1 <- tmlenet(data = df_netKmax6, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", f_gstar1 = 0L,
                    Qform = "Y ~ sum.netW3 + sum.netAW2",
                    hform.g0 = "netA ~ netW2 + sum.netW3 + nF",
                    hform.gstar = "netA ~ sum.netW3",
                    IDnode = "IDs", NETIDnode = "Net_str",
                    optPars = list(n_MCsims = 1))

res_K6_1$EY_gstar1$estimates
res_K6_1$EY_gstar1$vars
res_K6_1$EY_gstar1$CIs

#***************************************************************************************
# Run exactly the same estimators as above, 
# but using the output "DatNet.ObsP0" of eval.summaries as input to tmlenet:
#***************************************************************************************
res_K6_1b <- tmlenet(DatNet.ObsP0 = res$DatNet.ObsP0,
                    Anode = "A", f_gstar1 = 0L,
                    Qform = "Y ~ sum.netW3 + sum.netAW2",
                    hform.g0 = "netA ~ netW2 + sum.netW3 + nF",
                    hform.gstar = "netA ~ sum.netW3",
                    optPars = list(n_MCsims = 1))

res_K6_1b$EY_gstar1$estimates
res_K6_1b$EY_gstar1$vars
res_K6_1b$EY_gstar1$CIs

#***************************************************************************************
# Same as above but for covariate-based TMLE.
#***************************************************************************************
res_K6_2 <- tmlenet(data = df_netKmax6, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", f_gstar1 = 0L,
                    Qform = "Y ~ sum.netW3 + sum.netAW2",
                    hform.g0 = "netA ~ netW2 + sum.netW3 + nF",
                    hform.gstar = "netA ~ sum.netW3",
                    IDnode = "IDs", NETIDnode = "Net_str",
                    optPars = list(runTMLE = "tmle.covariate", n_MCsims = 1))

res_K6_2$EY_gstar1$estimates
res_K6_2$EY_gstar1$vars
res_K6_2$EY_gstar1$CIs

#***************************************************************************************
# SPECIFYING THE NETWORK AS A MATRIX OF FRIEND ROW NUMBERS:
#***************************************************************************************
net_ind_obj <- simcausal::NetIndClass$new(nobs = nrow(df_netKmax6), Kmax = Kmax)
# generating the network matrix from input data:
NetInd_mat <- net_ind_obj$makeNetInd.fromIDs(Net_str = df_netKmax6[, "Net_str"],
                                              IDs_str = df_netKmax6[, "IDs"])$NetInd
nF <- net_ind_obj$nF # number of friends

data(NetInd_mat_Kmax6)
all.equal(NetInd_mat, NetInd_mat_Kmax6) # TRUE

print(head(NetInd_mat))
print(head(nF))
print(all.equal(df_netKmax6[,"nFriends"], nF))

res_K6_net1 <- tmlenet(data = df_netKmax6, Kmax = Kmax, sW = def_sW, sA = def_sA,
                        Anode = "A", f_gstar1 = f.A_0,
                        Qform = "Y ~ sum.netW3 + sum.netAW2",
                        hform.g0 = "netA ~ netW2 + sum.netW3 + nF",
                        hform.gstar = "netA ~ sum.netW3",
                        NETIDmat = NetInd_mat,
                        optPars = list(runTMLE = "tmle.intercept", n_MCsims = 1))

all.equal(res_K6_net1$EY_gstar1$estimates, res_K6_1$EY_gstar1$estimates)
all.equal(res_K6_net1$EY_gstar1$vars, res_K6_1$EY_gstar1$vars)
all.equal(res_K6_net1$EY_gstar1$CIs, res_K6_1$EY_gstar1$CIs)

#***************************************************************************************
# EQUIVALENT WAYS OF SPECIFYING INTERVENTIONS f_gstar1/f_gstar2.
# LOWERING THE DIMENSIONALITY OF THE SUMMARY MEASURES.
#***************************************************************************************
def_sW <- def.sW(sum.netW3 = sum(W3[[1:Kmax]]), replaceNAw0=TRUE)
def_sA <- def.sA(sum.netAW2 = sum((1-A[[1:Kmax]])*W2[[1:Kmax]]), replaceNAw0=TRUE)

# can define intervention by function f.A_0 that sets everyone's A to constant 0:
res_K6_1 <- tmlenet(data = df_netKmax6, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", Ynode = "Y", f_gstar1 = f.A_0,
                    NETIDmat = NetInd_mat)
res_K6_1$EY_gstar1$estimates

# equivalent way to define intervention f.A_0 is to just set f_gstar1 to 0:
res_K6_1 <- tmlenet(data = df_netKmax6, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", Ynode = "Y", f_gstar1 = 0L,
                    NETIDmat = NetInd_mat)
res_K6_1$EY_gstar1$estimates

# or set f_gstar1 to a vector of 0's of length nrow(data):
res_K6_1 <- tmlenet(data = df_netKmax6, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", Ynode = "Y", f_gstar1 = rep_len(0L, nrow(df_netKmax6)),
                    NETIDmat = NetInd_mat)
res_K6_1$EY_gstar1$estimates

#***************************************************************************************
# EXAMPLE WITH SIMULATED DATA FOR AT MOST 2 FRIENDS AND 1 BASELINE COVARIATE W1
#***************************************************************************************
data(df_netKmax2)
head(df_netKmax2)
Kmax <- 2
# Define the summary measures:
def_sW <- def.sW(W1[[0:Kmax]])
def_sA <- def.sA(A[[0:Kmax]])
# Define the network matrix:
net_ind_obj <- simcausal::NetIndClass$new(nobs = nrow(df_netKmax2), Kmax = Kmax)
NetInd_mat <- net_ind_obj$makeNetInd.fromIDs(Net_str = df_netKmax2[, "Net_str"],
                              IDs_str = df_netKmax2[, "IDs"])$NetInd

#***************************************************************************************
# Mean population outcome under stochastic intervention P(A=1)=0.2
#***************************************************************************************
# Evaluates the target parameter by sampling exposures A from f_gstar1;
# Setting optPars$n_MCsims=100 means that A will be sampled 1000 times (
# for a total sample size of nrow(data)*n_MCsims under f_gstar1)
options(tmlenet.verbose = TRUE)
res_K2_1 <- tmlenet(data = df_netKmax2, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", Ynode = "Y", f_gstar1 = f.A_.2,
                    NETIDmat = NetInd_mat, optPars = list(n_MCsims = 100))
res_K2_1$EY_gstar1$estimates
res_K2_1$EY_gstar1$vars
res_K2_1$EY_gstar1$CIs

#***************************************************************************************
# Estimating the average treatment effect (ATE) for two static interventions:
# f_gstar1 sets everyone A=1 vs f_gstar2 sets everyone A=0;
#***************************************************************************************
res_K2_2 <- tmlenet(data = df_netKmax2, Kmax = Kmax, sW = def_sW, sA = def_sA,
                    Anode = "A", Ynode = "Y",
                    f_gstar1 = 1,
                    NETIDmat = NetInd_mat,
                    optPars = list(f_gstar2 = 0, n_MCsims = 1))
names(res_K2_2)

# Estimates under f_gstar1:
res_K2_2$EY_gstar1$estimates
res_K2_2$EY_gstar1$vars
res_K2_2$EY_gstar1$CIs

# Estimates under f_gstar2:
res_K2_2$EY_gstar2$estimates
res_K2_2$EY_gstar2$vars
res_K2_2$EY_gstar2$CIs

# ATE estimates for f_gstar1-f_gstar2:
res_K2_2$ATE$estimates
res_K2_2$ATE$vars
res_K2_2$ATE$CIs



}
\seealso{
\code{\link{tmlenet-package}} for the general overview of the package,
 \code{\link{def.sW}} for defining the summary measures, \code{\link{eval.summaries}} for
 evaluation and validation of the summary measures,
 and \code{\link{df_netKmax2}}/\code{\link{df_netKmax6}}/\code{\link{NetInd_mat_Kmax6}}
 for examples of network datasets.
}

