if (Sys.getenv("TMUX_BINARY") != "") {
  options(tmux_binary = Sys.getenv("TMUX_BINARY"))
}

# On macOS the path generated by tempdir() is too long for tmux and will result
# in an error, so use /tmp instead.
if (tolower(Sys.info()["sysname"]) == "darwin") {
  tmp_dir <- "/tmp"
} else {
  tmp_dir <- tempdir()
}

tmux_socket_path <- fs::file_temp(pattern = "tmux-socket-", tmp_dir = tmp_dir)
options(tmux_config_file = "/dev/null",
        tmux_socket_path = tmux_socket_path)
message("Socket path set to ", tmux_socket_path)

if (is_installed()) {
  message("Binary found: '", getOption("tmux_binary", "tmux"),
          "' with version: ", tmux_version(as_numeric = FALSE), ".")
} else {
  message("Binary not found, skipping tests.")
}

skip_if_tmux_not_installed <- function() {
  skip_if_not(is_installed())
}

Sys.sleep(0.1)
