% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_utils.R
\name{check_all_count}
\alias{check_all_count}
\title{Tabulate a range of check-all-that-apply response columns in a single table.}
\usage{
check_all_count(dat, ...)
}
\arguments{
\item{dat}{a data.frame with survey data}

\item{...}{unquoted column names containing the range of the answer choices.  Can be specified individually, as a range, i.e., \code{q1_1:q1_5}, or using other helper functions from \code{dplyr::select()}.}
}
\value{
a data.frame with the tabulated results (n and % of question respondents choosing each choice.)  This is an object of class \code{tabyl} which means that you can call \code{janitor::adorn_pct_formatting()} and it will format the correct columns.
}
\description{
This function is to be run on columns treated with \code{check_all_recode()}.

Takes a data.frame and range of columns containing all answer choices to a check-all-that-apply question and tabulates the results.  People who did not select any choices  (i.e., they did not answer the question) are omitted from the denominator.  For this to make sense, the question's choices should be MECE, or there should be an NA option.

This works with an "Other" open-response text field, which will be recoded to a binary variable with \code{check_all_recode}.
}
\examples{
x <- data.frame( # 4th person didn't respond at all
  unrelated = 1:5,
  q1_1 = c("a", "a", "a", NA, NA),
  q1_2 = c("b", "b", NA, NA, NA),
  q1_3 = c(NA, NA, "c", NA, NA),
  q1_other = c(NA, "something else", NA, NA, "not any of these")
)

x |>
  check_all_recode(q1_1:q1_other) |>
  check_all_count(q1_1:q1_other)

# You can use any of the dplyr::select() helpers to identify the columns:
x |>
  check_all_recode(contains("q1")) |>
  check_all_count(contains("q1"))
}
