% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environmental_variance.R
\name{environmental_variance}
\alias{environmental_variance}
\title{Environmental variance}
\usage{
environmental_variance(data, trait, genotype, unit.correct = FALSE)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analysized.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{unit.correct}{logical, default is \code{FALSE}, returning the stability index with unit equals to squared unit of trait; when \code{TRUE}, returning stability index with the unit as same as unit of trait.#'}
}
\value{
a data table with environmental variance
}
\description{
\code{environmental_variance} is used to calculate variance of a genotype across environments.
}
\details{
Environmental variance (Roemer, 1917) is calculated by squared and suming up all deviation from genotypic mean for each genotype.
The larger the environmental variance of one genotype is, the lower the stability.
Equation of environmental variance can be found in vignette file.
}
\examples{
data(Data)
environmental.variance <- environmental_variance(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 unit.correct = FALSE)
}
\references{
\insertRef{roemer1917}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{stability}
\keyword{static}
