% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan.R
\name{manhattan}
\alias{manhattan}
\title{Create a Manhattan plot}
\usage{
manhattan(
  df,
  ntop = 4,
  title = "",
  annotate = NULL,
  color = get_topr_colors(),
  sign_thresh = 5e-08,
  sign_thresh_color = "red",
  sign_thresh_label_size = 3.5,
  label_size = 3.5,
  size = 0.8,
  shape = 19,
  alpha = 1,
  highlight_genes_color = "darkred",
  highlight_genes_ypos = 1.5,
  axis_text_size = 12,
  axis_title_size = 14,
  title_text_size = 15,
  legend_title_size = 13,
  legend_text_size = 12,
  protein_coding_only = TRUE,
  angle = 0,
  legend_labels = NULL,
  chr = NULL,
  annotate_with = "Gene_Symbol",
  region_size = 2e+07,
  legend_name = NULL,
  legend_position = "bottom",
  nudge_x = 0.1,
  nudge_y = 0.7,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  highlight_genes = NULL,
  label_color = NULL,
  legend_nrow = NULL,
  gene_label_size = NULL,
  gene_label_angle = 0,
  scale = 1,
  show_legend = TRUE,
  sign_thresh_linetype = "dashed",
  sign_thresh_size = 0.5,
  rsids = NULL,
  rsids_color = NULL,
  rsids_with_vline = NULL,
  annotate_with_vline = NULL,
  shades_color = NULL,
  shades_alpha = 0.5,
  segment.size = 0.2,
  segment.color = "black",
  segment.linetype = "dashed",
  max.overlaps = 10,
  label_fontface = "plain",
  label_family = "",
  gene_label_fontface = "plain",
  gene_label_family = "",
  build = 38,
  verbose = NULL,
  label_alpha = 1,
  shades_line_alpha = 1,
  vline = NULL,
  vline_color = "grey",
  vline_linetype = "dashed",
  vline_alpha = 1,
  vline_size = 0.5,
  region = NULL,
  theme_grey = FALSE,
  xaxis_label = "Chromosome",
  use_shades = FALSE,
  even_no_chr_lightness = 0.8
)
}
\arguments{
\item{df}{Dataframe or a list of dataframes (required columns are \code{CHROM,POS,P}), in upper- or lowercase) of association results.}

\item{ntop}{An integer, number of datasets (GWAS results) to show on the top plot}

\item{title}{A string to set the plot title}

\item{annotate}{A number (p-value). Display annotation for variants with p-values below this threshold}

\item{color}{A string or a vector of strings, for setting the color of the datapoints on the plot}

\item{sign_thresh}{A number or vector of numbers, setting the horizontal significance threshold (default: \code{sign_thresh=5e-8}). Set to NULL to hide the significance threshold.}

\item{sign_thresh_color}{A string or vector of strings to set the color/s of the significance threshold/s}

\item{sign_thresh_label_size}{A number setting the text size of the label for the significance thresholds (default text size is 3.5)}

\item{label_size}{An number to set the size of the plot labels (default: \code{label_size=3})}

\item{size}{A number or a vector of numbers, setting the size of the plot points (default: \code{size=1.2})}

\item{shape}{A number of a vector of numbers setting the shape of the plotted points}

\item{alpha}{A number or a vector of numbers setting the transparency of the plotted points}

\item{highlight_genes_color}{A string, color for the highlighted genes (default: darkred)}

\item{highlight_genes_ypos}{An integer, controlling where on the y-axis the highlighted genes are placed (default value is 1)}

\item{axis_text_size}{A number, size of the x and y axes tick labels (default: 12)}

\item{axis_title_size}{A number, size of the x and y title labels (default: 12)}

\item{title_text_size}{A number, size of the plot title (default: 13)}

\item{legend_title_size}{A number, size of the legend title}

\item{legend_text_size}{A number, size of the legend text}

\item{protein_coding_only}{A logical scalar, if TRUE, only protein coding genes are used for annotation}

\item{angle}{A number, the angle of the text label}

\item{legend_labels}{A string or vector of strings representing legend labels for the input datasets}

\item{chr}{A string or integer, the chromosome to plot (i.e. chr15), only required if the input dataframe contains results from more than one chromosome}

\item{annotate_with}{A string. Annotate the variants with either Gene_Symbol or ID (default: "Gene_Symbol")}

\item{region_size}{An integer (default = 20000000) (or a string represented as 200kb or 2MB) indicating the window size for variant labeling. Increase this number for sparser annotation and decrease for denser annotation.}

\item{legend_name}{A string, use to change the name of the legend (default: None)}

\item{legend_position}{A string, top,bottom,left or right}

\item{nudge_x}{A number to vertically adjust the starting position of each gene label (this is a ggrepel parameter)}

\item{nudge_y}{A number to horizontally adjust the starting position of each gene label (this is a ggrepel parameter)}

\item{xmin, xmax}{Integer, setting the chromosomal range to display on the x-axis}

\item{ymin, ymax}{Integer, min and max of the y-axis, (default values: \code{ymin=0, ymax=max(-log10(df$P))})}

\item{highlight_genes}{A string or vector of strings, gene or genes to highlight at the bottom of the plot}

\item{label_color}{A string or a vector of strings. To change the color of the gene or variant labels}

\item{legend_nrow}{An integer, sets the number of rows allowed for the legend labels}

\item{gene_label_size}{A number setting the size of the gene labels shown at the bottom of the plot}

\item{gene_label_angle}{A number setting the angle of the gene label shown at the bottom of the plot (default: 0)}

\item{scale}{A number, to change the size of the title and axes labels and ticks at the same time (default : 1)}

\item{show_legend}{A logical scalar, set to FALSE to hide the legend (default : TRUE)}

\item{sign_thresh_linetype}{A string, the line-type of the horizontal significance threshold (default : dashed)}

\item{sign_thresh_size}{A number, sets the size of the horizontal significance threshold line (default : 1)}

\item{rsids}{A string (rsid) or vector of strings to highlight on the plot, e.g. \code{rsids=c("rs1234, rs45898")}}

\item{rsids_color}{A string, the color of the variants in variants_id (default color is red)}

\item{rsids_with_vline}{A string (rsid) or vector of strings to highlight on the plot with their rsids and vertical lines further highlighting their positions}

\item{annotate_with_vline}{A number (p-value). Display annotation and vertical lines for variants with p-values below this threshold}

\item{shades_color}{The color of the rectangles (shades) representing the different chromosomes on the Manhattan plot}

\item{shades_alpha}{The transparency (alpha) of the rectangles (shades)}

\item{segment.size}{line segment color (ggrepel argument)}

\item{segment.color}{line segment thickness (ggrepel argument)}

\item{segment.linetype}{line segment solid, dashed, etc.(ggrepel argument)}

\item{max.overlaps}{Exclude text labels that overlap too many things. Defaults to 10 (ggrepel argument)}

\item{label_fontface}{A string or a vector of strings. Label font “plain”, “bold”, “italic”, “bold.italic” (ggrepel argument)}

\item{label_family}{A string or a vector of strings. Label font name (default ggrepel argument is "")}

\item{gene_label_fontface}{Gene label font “plain”, “bold”, “italic”, “bold.italic” (ggrepel argument)}

\item{gene_label_family}{Gene label font name (default ggrepel argument is "")}

\item{build}{A number representing the genome build. Set to 37 to change to build (GRCh37). The default is build 38 (GRCh38).}

\item{verbose}{A logical scalar (default: NULL). Set to FALSE to suppress printed messages}

\item{label_alpha}{An number or vector of numbers to set the transparency of the plot labels (default: \code{label_alpha=1})}

\item{shades_line_alpha}{The transparency (alpha) of the lines around the rectangles (shades)}

\item{vline}{A number or vector of numbers to add a vertical line to the plot at a specific chromosomal position, e.g \code{vline=chr1:204000066}. Multiple values can be provided in a vector, e.g  \code{vline=c(chr1:204000066,chr5:100500188)}}

\item{vline_color}{The color of added vertical line/s (default: grey)}

\item{vline_linetype}{The linetype of added vertical line/s (default : dashed)}

\item{vline_alpha}{The alpha of added vertical line/s (default : 1)}

\item{vline_size}{The size of added vertical line/s (default : 0.5)}

\item{region}{A string representing a genetic region, e.g. chr1:67038906-67359979}

\item{theme_grey}{Use gray rectangles (instead of white to distinguish between chromosomes)}

\item{xaxis_label}{The label for the x-axis (default: Chromosome)}

\item{use_shades}{Use shades/rectangles to distinguish between chromosomes}

\item{even_no_chr_lightness}{Lightness value for even numbered chromosomes. A number or vector of numbers between 0 and 1 (default: 0.8). If set to 0.5, the same color as shown for odd numbered chromosomes is displayed. A value below 0.5 will result in a darker color displayed for even numbered chromosomes, whereas a value above 0.5 results in a lighter color.}
}
\value{
ggplot object
}
\description{
\code{manhattan()} displays association results for the entire genome on a Manhattan plot.
Required parameter is at least one dataset (dataframe) containing the association data (with columns \code{CHROM,POS,P} in upper or lowercase)

All other input parameters are optional
}
\examples{
\dontrun{
manhattan(CD_UKBB)
}
}
