% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_logical_xor}
\alias{torch_logical_xor}
\title{Logical_xor}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{other}{(Tensor) the tensor to compute XOR with}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Logical_xor
}
\section{logical_xor(input, other, out=None) -> Tensor }{


Computes the element-wise logical XOR of the given input tensors. Zeros are treated as \code{False} and nonzeros are
treated as \code{True}.
}

\examples{
if (torch_is_installed()) {

torch_logical_xor(torch_tensor(c(TRUE, FALSE, TRUE)), torch_tensor(c(TRUE, FALSE, FALSE)))
a = torch_tensor(c(0, 1, 10, 0), dtype=torch_int8())
b = torch_tensor(c(4, 0, 1, 0), dtype=torch_int8())
torch_logical_xor(a, b)
torch_logical_xor(a$to(dtype=torch_double()), b$to(dtype=torch_double()))
torch_logical_xor(a$to(dtype=torch_double()), b)
}
}
