% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/device.R
\name{torch_device}
\alias{torch_device}
\title{Create a Device object}
\usage{
torch_device(type, index = NULL)
}
\arguments{
\item{type}{(character) a device type \code{"cuda"} or \code{"cpu"}}

\item{index}{(integer) optional device ordinal for the device type.  If the device ordinal
is not present, this object will always represent the current device for the device
type, even after \code{torch_cuda_set_device()} is called; e.g., a \code{torch_tensor} constructed
with device \code{'cuda'} is equivalent to \code{'cuda:X'} where X is the result of
\code{torch_cuda_current_device()}.

A \code{torch_device} can be constructed via a string or via a string and device ordinal}
}
\description{
A \code{torch_device}  is an object representing the device on which a \code{torch_tensor}
is or will be allocated.
}
\examples{
if (torch_is_installed()) {

# Via string
torch_device("cuda:1")
torch_device("cpu")
torch_device("cuda") # current cuda device

# Via string and device ordinal
torch_device("cuda", 0)
torch_device("cpu", 0)

}
}
