% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-padding.R
\name{nnf_pad}
\alias{nnf_pad}
\title{Pad}
\usage{
nnf_pad(input, pad, mode = "constant", value = NULL)
}
\arguments{
\item{input}{(Tensor) N-dimensional tensor}

\item{pad}{(tuple) m-elements tuple, where \eqn{\frac{m}{2} \leq} input dimensions
and \eqn{m} is even.}

\item{mode}{'constant', 'reflect', 'replicate' or 'circular'. Default: 'constant'}

\item{value}{fill value for 'constant' padding. Default: 0.}
}
\description{
Pads tensor.
}
\section{Padding size}{


The padding size by which to pad some dimensions of \code{input}
are described starting from the last dimension and moving forward.
\eqn{\left\lfloor\frac{\mbox{len(pad)}}{2}\right\rfloor} dimensions
of \code{input} will be padded.
For example, to pad only the last dimension of the input tensor, then
\code{pad} has the form
\eqn{(\mbox{padding\_left}, \mbox{padding\_right})};
to pad the last 2 dimensions of the input tensor, then use
\eqn{(\mbox{padding\_left}, \mbox{padding\_right},}
\eqn{\mbox{padding\_top}, \mbox{padding\_bottom})};
to pad the last 3 dimensions, use
\eqn{(\mbox{padding\_left}, \mbox{padding\_right},}
\eqn{\mbox{padding\_top}, \mbox{padding\_bottom}}
\eqn{\mbox{padding\_front}, \mbox{padding\_back})}.
}

\section{Padding mode}{


See \code{nn_constant_pad_2d}, \code{nn_reflection_pad_2d}, and
\code{nn_replication_pad_2d} for concrete examples on how each of the
padding modes works. Constant padding is implemented for arbitrary dimensions.
tensor, or the last 2 dimensions of 4D input tensor, or the last dimension of
3D input tensor. Reflect padding is only implemented for padding the last 2
dimensions of 4D input tensor, or the last dimension of 3D input tensor.
}

