% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R, R/wrapers.R
\name{torch_fft_fft}
\alias{torch_fft_fft}
\title{Fft}
\usage{
torch_fft_fft(self, n = NULL, dim = -1L, norm = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor}

\item{n}{(int) Signal length. If given, the input will either be zero-padded
or trimmed to this length before computing the FFT.}

\item{dim}{(int, optional) The dimension along which to take the one dimensional FFT.}

\item{norm}{(str, optional) Normalization mode. For the forward transform, these
correspond to:
\itemize{
\item "forward" - normalize by 1/n
\item "backward" - no normalization
\item "ortho" - normalize by 1/sqrt(n) (making the FFT orthonormal)
Calling the backward transform (ifft()) with the same normalization mode will
apply an overall normalization of 1/n between the two transforms. This is
required to make IFFT the exact inverse.
Default is "backward" (no normalization).
}}
}
\description{
Computes the one dimensional discrete Fourier transform of input.
}
\note{
The Fourier domain representation of any real signal satisfies the Hermitian
property: \verb{X[i] = conj(X[-i]).} This function always returns both the positive
and negative frequency terms even though, for real inputs, the negative
frequencies are redundant. rfft() returns the more compact one-sided representation
where only the positive frequencies are returned.
}
\examples{
if (torch_is_installed()) {
t <- torch_arange(start = 0, end = 3)
t
torch_fft_fft(t, norm = "backward")

}
}
