% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_torch}
\alias{install_torch}
\title{Install Torch}
\usage{
install_torch(
  version = "1.11.0",
  type = install_type(version = version),
  reinstall = FALSE,
  path = install_path(),
  timeout = 360,
  ...
)
}
\arguments{
\item{version}{The Torch version to install.}

\item{type}{The installation type for Torch. Valid values are \code{"cpu"} or the 'CUDA' version.}

\item{reinstall}{Re-install Torch even if its already installed?}

\item{path}{Optional path to install or check for an already existing installation.}

\item{timeout}{Optional timeout in seconds for large file download.}

\item{...}{other optional arguments (like \code{`load`} for manual installation).}
}
\description{
Installs Torch and its dependencies.
}
\details{
When using \code{path} to install in a specific location, make sure the \code{TORCH_HOME} environment
variable is set to this same path to reuse this installation. The \code{TORCH_INSTALL} environment
variable can be set to \code{0} to prevent auto-installing torch and \code{TORCH_LOAD} set to \code{0}
to avoid loading dependencies automatically. These environment variables are meant for advanced use
cases and troubleshooting only.
When timeout error occurs during library archive download, or length of downloaded files differ from
reported length, an increase of the \code{timeout} value should help.

Setting the environmanet variable \code{PRECXX11ABI=1} will trigger the installation of
a Pre-cxx11 ABI installation of LibTorch. This can be useful in environments with
older versions of GLIBC like CentOS7 and older Debian/Ubuntu versions.
}
