% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_create_dct}
\alias{functional_create_dct}
\title{DCT transformation matrix (functional)}
\usage{
functional_create_dct(n_mfcc, n_mels, norm = NULL)
}
\arguments{
\item{n_mfcc}{(int): Number of mfc coefficients to retain}

\item{n_mels}{(int): Number of mel filterbanks}

\item{norm}{(chr or NULL): Norm to use (either 'ortho' or NULL)}
}
\value{
\code{tensor}: The transformation matrix, to be right-multiplied to
row-wise data of size (\code{n_mels}, \code{n_mfcc}).
}
\description{
Create a DCT transformation matrix with shape (\code{n_mels}, \code{n_mfcc}),
normalized depending on norm.
\url{https://en.wikipedia.org/wiki/Discrete_cosine_transform}
}
