% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-misc_ops.R
\name{internal__normalize_audio}
\alias{internal__normalize_audio}
\title{Audio Normalization}
\usage{
internal__normalize_audio(signal, normalization = TRUE)
}
\arguments{
\item{signal}{(Tensor): waveform}

\item{normalization}{(bool, int or function): Optional normalization.
If boolean \code{TRUE}, then output is divided by \code{2^31}.
Assuming the input is signed 32-bit audio, this normalizes to \verb{[-1, 1]}.
If \code{numeric}, then output is divided by that number.
If \code{function}, then the output is passed as a paramete to the given function,
then the output is divided by the result. (Default: \code{TRUE})}
}
\description{
Audio normalization of a tensor in-place.  The normalization can be a bool,
a number, or a function that takes the audio tensor as an input. SoX uses
32-bit signed integers internally, thus bool normalizes based on that assumption.
}
\keyword{internal}
