% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{transform_mu_law_encoding}
\alias{transform_mu_law_encoding}
\title{Mu Law Encoding}
\usage{
transform_mu_law_encoding(quantization_channels = 256)
}
\arguments{
\item{quantization_channels}{(int, optional): Number of channels. (Default: \code{256})}
}
\value{
x_mu (Tensor): An encoded signal.
}
\description{
Encode signal based on mu-law companding.  For more info see
the \href{https://en.wikipedia.org/wiki/M-law_algorithm}{Wikipedia Entry}
}
\details{
forward param:
x  (Tensor): A signal to be encoded.

This algorithm assumes the signal has been scaled to between -1 and 1 and
returns a signal encoded with values from 0 to quantization_channels - 1.
}
