% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterWord.R
\name{filterWord}
\alias{filterWord}
\title{Subcorpus With Word Filter}
\usage{
filterWord(object, text, search, ignore.case = FALSE, out = c("text",
  "bin", "count"))
}
\arguments{
\item{object}{A \code{\link{textmeta}} object}

\item{text}{Not necessary if \code{object} is specified, else should be
\code{object\$text}: list of article texts.}

\item{search}{List of data frames. Every List element is an 'or'
link, every entry in a data frame is linked by an 'and'. The dataframe must have following tree variables: \code{pattern} a character string including the search terms, \code{word}, a logical value displaying if a word (TRUE) or character (search) is wanted and \code{count} an integer marking how many times the word must at least be found in the text. \code{word} can alternatively be a character string containing the keywords \code{pattern} for character search, \code{word} for word-search and \code{left} and \code{right} for truncated search.
If \code{wordlist} is only a character Vector the link is 'or', and a character search will be used with \code{count=1}}

\item{ignore.case}{Logical: Lower and upper case will be ignored.}

\item{out}{Type of output: \code{text} filtered corpus, \code{bin} logical vector for all texts, \code{count} the number of matches (max one match per character string).}
}
\value{
Filtered list of texts.
}
\description{
Generates a subcorpus by restricting it to texts containing specific filter Words
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

# search for pattern "fish"
filterWord(text=texts, search="fish", ignore.case=TRUE)

# search for word "fish"
filterWord(text=texts, search=data.frame(pattern="fish", word="word", count=1),
ignore.case=TRUE)

# pattern must appear at least two times
filterWord(text=texts, search=data.frame(pattern="fish", word="pattern", count=2),
ignore.case=TRUE)

# search for "fish" AND "day"
filterWord(text=texts, search=data.frame(pattern=c("fish", "day"), word="word", count=1),
ignore.case=TRUE)

# search for "Thanks" OR "integrals"
filterWord(text=texts, search=list(data.frame(pattern="Thanks", word="word", count=1),
data.frame(pattern="integrals", word="word", count=1)))


}
