% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterDate.R
\name{filterDate}
\alias{filterDate}
\alias{filterDate.default}
\alias{filterDate.textmeta}
\title{Subcorpus With Date Filter}
\usage{
filterDate(...)

\method{filterDate}{default}(
  text,
  meta,
  s.date = min(meta$date, na.rm = TRUE),
  e.date = max(meta$date, na.rm = TRUE),
  ...
)

\method{filterDate}{textmeta}(
  object,
  s.date = min(object$meta$date, na.rm = TRUE),
  e.date = max(object$meta$date, na.rm = TRUE),
  filtermeta = TRUE,
  ...
)
}
\arguments{
\item{...}{Not used.}

\item{text}{Not necessary if \code{object} is specified, else should be
\code{object$text}}

\item{meta}{Not necessary if \code{object} is specified, else should be
\code{object$meta}}

\item{s.date}{Start date of subcorpus as date object}

\item{e.date}{End date of subcorpus as date object}

\item{object}{\code{\link{textmeta}} object}

\item{filtermeta}{Logical: Should the meta component be filtered, too?}
}
\value{
\code{\link{textmeta}} object if \code{object} is specified,
else only the filtered \code{text}. If a \code{\link{textmeta}} object is
returned its meta data are filtered to those texts which appear in the corpus
by default (\code{filtermeta}).
}
\description{
Generates a subcorpus by restricting it to a specific time window.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

subcorpus <- filterDate(object=corpus, s.date = "1951-05-06")
subcorpus$meta
subcorpus$text
}
\keyword{manip}
