% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intruderWords.R
\name{intruderWords}
\alias{intruderWords}
\title{Function to validate the fit of the LDA model}
\usage{
intruderWords(
  beta = NULL,
  byScore = TRUE,
  numTopwords = 30L,
  numIntruder = 1L,
  numOutwords = 5L,
  noTopic = TRUE,
  printSolution = FALSE,
  oldResult = NULL,
  test = FALSE,
  testinput = NULL
)
}
\arguments{
\item{beta}{A matrix of word-probabilities or frequency table for the topics (e.g. the \code{topics} matrix from the \code{\link{LDAgen}} result). Each row is a topic, each column a word. The rows will be divided by the row sums, if they are not 1.}

\item{byScore}{Logical: Should the score of \code{top.topic.words} from the \code{lda} package be used?}

\item{numTopwords}{The number of topwords to be used for the intruder words}

\item{numIntruder}{Intended number of intruder words. If \code{numIntruder} is a integer vector, the number would be sampled for each topic.}

\item{numOutwords}{Integer: Number of words per topic, including the intruder words.}

\item{noTopic}{Logical: Is \code{x} input allowed to mark nonsense topics?}

\item{printSolution}{tba}

\item{oldResult}{Result object from an unfinished run of \code{intruderWords}. If oldResult is used, all other parameter will be ignored.}

\item{test}{Logical: Enables test mode}

\item{testinput}{Input for function tests}
}
\value{
Object of class \code{IntruderWords}. List of 7
\item{result}{Matrix of 3 columns. Each row represents one topic. All values are 0 if the topic did not run before. \code{numIntruder} (1. column) gives the number of intruder words inputated in this topic, \code{missIntruder} (2. column) the number of the intruder words which were not found by the coder and \code{falseIntruder} (3. column) the number of the words choosen by the coder which were no intruder.}
\item{beta}{Parameter of the function call}
\item{byScore}{Parameter of the function call}
\item{numTopwords}{Parameter of the function call}
\item{numIntruder}{Parameter of the function call}
\item{numOutwords}{Parameter of the function call}
\item{noTopic}{Parameter of the function call}
}
\description{
This function validates a LDA result by presenting a mix of words from a topic and intruder words to a human user, who has to identity them.
}
\examples{
\dontrun{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)
intruder <- intruderWords(beta=LDAresult$topics)}
}
\references{
Chang, Jonathan and Sean Gerrish and Wang, Chong and Jordan L. Boyd-graber and David M. Blei. Reading Tea Leaves: How Humans Interpret Topic Models. Advances in Neural Information Processing Systems, 2009.
}
