% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intruderTopics.R
\name{intruderTopics}
\alias{intruderTopics}
\title{Function to validate the fit of the LDA model}
\usage{
intruderTopics(
  text = NULL,
  beta = NULL,
  theta = NULL,
  id = NULL,
  numIntruder = 1,
  numOuttopics = 4,
  byScore = TRUE,
  minWords = 0L,
  minOuttopics = 0L,
  stopTopics = NULL,
  printSolution = FALSE,
  oldResult = NULL,
  test = FALSE,
  testinput = NULL
)
}
\arguments{
\item{text}{A list of texts (e.g. the text element of a \code{\link{textmeta}} object).}

\item{beta}{A matrix of word-probabilities or frequency table for the topics (e.g. the \code{topics} matrix from the \code{\link{LDAgen}} result). Each row is a topic, each column a word. The rows will be divided by the row sums, if they are not 1.}

\item{theta}{A matrix of wordcounts per text and topic (e.g. the \code{document_sums} matrix from the \code{\link{LDAgen}} result). Each row is a topic, each column a text. In each cell stands the number of words in text j belonging to topic i.}

\item{id}{Optional: character vector of text IDs that should be used for the function. Useful to start a inchoate coding task.}

\item{numIntruder}{Intended number of intruder words. If \code{numIntruder} is a integer vector, the number would be sampled for each topic.}

\item{numOuttopics}{tba Integer: Number of words per topic, including the intruder words}

\item{byScore}{Logical: Should the score of \code{top.topic.words} from the \code{lda} package be used?}

\item{minWords}{Integer: Minimum number of words for a choosen text.}

\item{minOuttopics}{Integer: Minimal number of words a topic needs to be classified as a possible correct Topic.}

\item{stopTopics}{Optional: Integer vector to deselect stopword topics for the coding task.}

\item{printSolution}{Logical: If \code{TRUE} the coder gets a feedback after his/her vote.}

\item{oldResult}{Result object from an unfinished run of \code{intruderWords}. If oldResult is used, all other parameter will be ignored.}

\item{test}{Logical: Enables test mode}

\item{testinput}{Input for function tests}
}
\value{
Object of class \code{IntruderTopics}. List of 11
\item{result}{Matrix of 3 columns. Each row represents one labeled text. \code{numIntruder} (1. column) gives the number of intruder topics inputated in this text, \code{missIntruder} (2. column) the number of the intruder topics which were not found by the coder and \code{falseIntruder} (3. column) the number of the topics choosen by the coder which were no intruder.}
\item{beta}{Parameter of the function call}
\item{theta}{Parameter of the function call}
\item{id}{Charater Vector of IDs at the beginning}
\item{byScore}{Parameter of the function call}
\item{numIntruder}{Parameter of the function call}
\item{numOuttopics}{Parameter of the function call}
\item{minWords}{Parameter of the function call}
\item{minOuttopics}{Parameter of the function call}
\item{unusedID}{Character vector of unused text IDs for the next run}
\item{stopTopics}{Parameter of the function call}
}
\description{
This function validates a LDA result by presenting a mix of topics and intruder topics to a human user, who has to identity them.
}
\examples{
\dontrun{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)
intruder <- intruderTopics(text=politics$text, beta=LDAresult$topics,
                           theta=LDAresult$document_sums, id=names(poliLDA))
}
}
\references{
Chang, Jonathan and Sean Gerrish and Wang, Chong and Jordan L. Boyd-graber and David M. Blei. Reading Tea Leaves: How Humans Interpret Topic Models. Advances in Neural Information Processing Systems, 2009.
}
