% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_slice.r
\name{manual_slice}
\alias{manual_slice}
\title{Manually slice along a variable axis.}
\usage{
manual_slice(
  data,
  proj,
  var = 1,
  nsteps = 20,
  v_rel = 0.01,
  rescale = FALSE,
  sphere = FALSE,
  col = "black",
  half_range = NULL,
  anchor_nav = "topright",
  palette = "Zissou 1",
  ...
)
}
\arguments{
\item{data}{numeric matrix, with n rows and p columns}

\item{proj}{projection from which slices are constructed}

\item{var}{variable axis to run the center along: 1, ..., p}

\item{nsteps}{number of changes in center to make}

\item{v_rel}{relative volume of the slice. If not set, suggested value
is calculated and printed to the screen.}

\item{rescale}{Default FALSE. If TRUE, rescale all variables to range [0,1]?}

\item{sphere}{if true, sphere all variables}

\item{col}{color to use for points, can be a vector or hexcolors or a factor.  Defaults to "black".}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{anchor_nav}{position of the anchor: center, topright or off}

\item{palette}{name of color palette for point colour, used by \code{\link{hcl.colors}}, default "Zissou 1"}

\item{...}{other options passed to output device}
}
\description{
The manual slice tour takes the current projection, with display_slice,
and changes the slice center.
}
\examples{
# Note that you might need to use the quartz()
# on OSX to see the animation
sphere5 <- data.frame(geozoo::sphere.hollow(5)$points)
proj <- basis_random(5, 2)
manual_slice(sphere5, proj, var=3, nsteps=10, rescale=TRUE, half_range=1.5)
}
