
# tr.iatgen

Translate Qualtrics qsf file (assumes qsf is in english and generated by a compatible version of iatgen package).

<!-- badges: start -->
<!-- badges: end -->

The goal of tr.iatgen is to ...

## Installation

You can install the development version of tr.iatgen:

``` r
devtools::install("iatgen/tr.iatgen");
```

## Capabilities

### List built-in translations

``` r
library(tr.iatgen)
available.languages()
```

``` output
      Code  Source              Target                    Description
1    en_en English             English             English to English
2    en_jp English            Japanese            English to Japanese
3    en_pt English           Portugese           English to Portugese
4 en_pt-BR English Portugese Brazilian English to Portugese Brazilian
5    en_tr English             Turkish             English to Turkish
```

### Export translation file template

``` r
library(tr.iatgen)
export.template()
```

``` output
[1] "/Library/Frameworks/R.framework/Versions/4.2-arm64/Resources/library/tr.iatgen/templates/en_en.csv"
```

### Validate external translation file

``` r
library(tr.iatgen)
validate.language(file="en_cs.csv")
```

``` output
[1] "cs"
```


### Translate qsf file

``` r
library(tr.iatgen)
translate.qsf(file="iat-flowins.qsf", lang="pt", dst_file="iat-flowins_pt.qsf")
```

``` output
[1] "iat-flowins_pt.qsf"
```

### Run a built-in shiny app to facilitate qsf file translation


``` r
library(tr.iatgen)
tr.iatgen::runApp()
```

![runApp output](https://github.com/iatgen/tr.iatgen/blob/main/vignettes/runApp.png?raw=true)


## Translation identifier format

```{source language}_{destination language}```

Where source and destination languages are defined in BCP47[^1] and IANA[^2].

Examples:
```
en_pt-BR -- English translation to Portuguese
en_ja    -- English translation to Japanese
``` 


[^1]: Tags for Identifying Languages, https://www.rfc-editor.org/rfc/bcp/bcp47.txt
[^2]: Language Subtag Registry, https://www.iana.org/assignments/language-subtag-registry/language-subtag-registry

