% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcPCA.R
\name{profile2fd}
\alias{profile2fd}
\title{Transform distribution and concentration profiles to functional data objects of class fd.}
\usage{
profile2fd(object, what, ...)
}
\arguments{
\item{object}{An object of class \code{distrProfile} or \code{conProfile}, as returned by \code{\link{distributionProfile}} and \code{\link{concentrationProfile}}, respectively.}

\item{what}{The variable for which the profiles should be transformed to a functional data object.}

\item{...}{Additional arguments passed on to \code{\link[fda]{Data2fd}}}
}
\value{
An object of class \code{\link[fda]{fd}}.
}
\description{
Transform distribution and concentration profiles to functional data objects of class fd.
}
\examples{
library("fda")
data("runs", package = "trackeR")
dp <- distributionProfile(runs, what = "speed")
dpFun <- profile2fd(dp, what = "speed",
    fdnames = list("speed", "sessions", "time above threshold"))
dp.pca <- pca.fd(dpFun, nharm = 4)
## 1st harmonic  captures vast majority of the variation
dp.pca$varprop
## time spent above speed = 0 is the characteristic distinguishing the profiles
plot(dp.pca, harm = 1)
sumRuns <- summary(runs)
plot(sumRuns$durationMoving, dp.pca$scores[,1])
}
