\name{MriImageMetadata}
\alias{MriImageMetadata}
\alias{metadata.image.mri}
\alias{isMriImageMetadata}
\title{Class representing metadata associated with an MRI image}
\description{
  This class represents MRI image metadata. An object of this class contains various information about an image, such as its image and voxel dimensions, coordinate origin and storage data type. An object of type \code{\link{MriImage}} can be treated as a metadata object, since the latter is always embedded in it.
}
\usage{
isMriImageMetadata(object)
}
\arguments{
  \item{object}{Any object.}
}
\value{
  A list object (see \code{\link{list.object}}) with class \code{c("metadata.image.mri", "list.object", "list")} and the following function elements.
  \item{getDataType()}{Retrieve a list describing the storage data type of the image. See \code{\link{getDataTypeByNiftiCode}} for details.}
  \item{getDimensionality()}{Retrieve a numeric vector of length 1 giving the number of dimensions in the image.}
  \item{getDimensions()}{Retrieve a numeric vector giving the dimensions of the image in voxels.}
  \item{getEndianness()}{Retrieve the endianness of the original or stored image. Either "big" or "little".}
  \item{getFieldOfView()}{Retrieve a numeric vector giving the dimensions of the image in spatial units, typically mm.}
  \item{getOrigin()}{Retrieve the coordinate origin of the image.}
  \item{getSource()}{Retrieve a character vector of length 1 giving the source file for the image. Returns "internal" if the image was not read from a file.}
  \item{getVoxelDimensions()}{Retrieve a numeric vector giving the dimensions of the image voxels in spatial units, typically mm.}
  \item{getVoxelUnit()}{Retrieve the spatial unit used by getVoxelDimensions(). The most common value is "mm".}
  \item{isInternal()}{Retrieve a logical value indicating whether the image was generated by a function, rather than read from a file.}
  \item{setEndianness(newEndian)}{Set the storage endianness of the image.}
  \item{setSource(newSource)}{Set the source of the image.}
  \item{summarise()}{Prints a summary of the metadata at output level \code{OL$Info} (see \code{\link{output}}).}
  \code{isMriImageMetadata} returns TRUE if \code{object} is an MriImageMetadata object.
}
\author{Jon Clayden}
\seealso{\code{\link{list.object}}, which this class extends. \code{\link{newMriImageMetadataFromTemplate}} for creating metadata objects.}
