% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_mri_image.R
\name{mergeMriImages}
\alias{mergeMriImages}
\title{Merging MriImage objects}
\usage{
mergeMriImages(..., bindDim = NULL, padTags = FALSE)
}
\arguments{
\item{...}{\code{MriImage} objects. They do not need to have the same
dimensionality.}

\item{bindDim}{An integer specifying the dimension along which to bind the
data, or \code{NULL} (the default). The latter case resolves to one number
higher than the last dimension common to all images.}

\item{padTags}{Logical value. If \code{TRUE}, \code{NA}s will be used to pad
tags which appear to be partially missing in the merged dataset. If
\code{FALSE}, incomplete tags will be dropped.}
}
\value{
A merged image.
}
\description{
This function concatenates the data from a series of \code{MriImage}
objects, and then attempts to work out the final dimensions of the merged
image and returns it.
}
\note{
Tags are retained as-is if they are identical in each image. Otherwise
  they are concatenated if their lengths match the number of blocks in each
  image, or concatenated with NAs for missing values if \code{padTags} is
  \code{TRUE}.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{http://www.jstatsoft.org/v44/i08/}.
}
\seealso{
\code{\linkS4class{MriImage}}
}
\author{
Jon Clayden
}
